/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model;

import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextBox;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextRun;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.StrokeStyle;
import ai2.org.apache.poi.sl.usermodel.VerticalAlignment;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.SuppressForbidden;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PPGraphics2D
extends Graphics2D
implements Cloneable {
    protected POILogger log = POILogFactory.getLogger(this.getClass());
    private HSLFGroupShape _group;
    private AffineTransform _transform;
    private Stroke _stroke;
    private Paint _paint;
    private Font _font;
    private Color _foreground;
    private Color _background;
    private RenderingHints _hints;

    public PPGraphics2D(HSLFGroupShape hSLFGroupShape) {
        this._group = hSLFGroupShape;
        this._transform = new AffineTransform();
        this._stroke = new BasicStroke();
        this._paint = Color.black;
        this._font = new Font("Arial", 0, 12);
        this._background = Color.black;
        this._foreground = Color.white;
        this._hints = new RenderingHints(null);
    }

    public HSLFGroupShape getShapeGroup() {
        return this._group;
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font font) {
        this._font = font;
    }

    @Override
    public Color getColor() {
        return this._foreground;
    }

    @Override
    public void setColor(Color color) {
        this.setPaint(color);
    }

    @Override
    public Stroke getStroke() {
        return this._stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this._stroke = stroke;
    }

    @Override
    public Paint getPaint() {
        return this._paint;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this._paint = paint;
        if (paint instanceof Color) {
            this._foreground = (Color)paint;
        }
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this._transform = new AffineTransform(affineTransform);
    }

    @Override
    public void draw(Shape shape) {
        GeneralPath generalPath = new GeneralPath(this._transform.createTransformedShape(shape));
        HSLFFreeformShape hSLFFreeformShape = new HSLFFreeformShape(this._group);
        hSLFFreeformShape.setPath(generalPath);
        hSLFFreeformShape.getFill().setForegroundColor(null);
        this.applyStroke(hSLFFreeformShape);
        if (this._paint instanceof Color) {
            hSLFFreeformShape.setLineColor((Color)this._paint);
        }
        this._group.addShape(hSLFFreeformShape);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        HSLFTextBox hSLFTextBox = new HSLFTextBox(this._group);
        hSLFTextBox.getTextParagraphs().get(0).supplySheet(this._group.getSheet());
        hSLFTextBox.setText(string);
        HSLFTextRun hSLFTextRun = hSLFTextBox.getTextParagraphs().get(0).getTextRuns().get(0);
        hSLFTextRun.setFontSize(Double.valueOf(this._font.getSize()));
        hSLFTextRun.setFontFamily(this._font.getFamily());
        if (this.getColor() != null) {
            hSLFTextRun.setFontColor(DrawPaint.createSolidPaint(this.getColor()));
        }
        if (this._font.isBold()) {
            hSLFTextRun.setBold(true);
        }
        if (this._font.isItalic()) {
            hSLFTextRun.setItalic(true);
        }
        hSLFTextBox.setBottomInset(0.0);
        hSLFTextBox.setTopInset(0.0);
        hSLFTextBox.setLeftInset(0.0);
        hSLFTextBox.setRightInset(0.0);
        hSLFTextBox.setWordWrap(2);
        hSLFTextBox.setHorizontalCentered(false);
        hSLFTextBox.setVerticalAlignment(VerticalAlignment.MIDDLE);
        TextLayout textLayout = new TextLayout(string, this._font, this.getFontRenderContext());
        float f3 = textLayout.getAscent();
        float f4 = (float)Math.floor(textLayout.getAdvance());
        float f5 = f3 * 2.0f;
        hSLFTextBox.setAnchor(new Rectangle((int)f, (int)(f2 -= f5 / 2.0f + f3 / 2.0f), (int)f4, (int)f5));
        this._group.addShape(hSLFTextBox);
    }

    @Override
    public void fill(Shape shape) {
        GeneralPath generalPath = new GeneralPath(this._transform.createTransformedShape(shape));
        HSLFFreeformShape hSLFFreeformShape = new HSLFFreeformShape(this._group);
        hSLFFreeformShape.setPath(generalPath);
        this.applyPaint(hSLFFreeformShape);
        hSLFFreeformShape.setLineColor(null);
        this._group.addShape(hSLFFreeformShape);
    }

    @Override
    public void translate(int n, int n2) {
        this._transform.translate(n, n2);
    }

    @Override
    public void clip(Shape shape) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public Shape getClip() {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return null;
    }

    @Override
    public void scale(double d, double d2) {
        this._transform.scale(d, d2);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.draw(float_);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.fill(float_);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.fill(float_);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 2);
        this.fill(float_);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 0);
        this.draw(float_);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            this.draw(generalPath);
        }
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        Line2D.Float float_ = new Line2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.fill(polygon);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.fill(rectangle);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.draw(polygon);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(Shape shape) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public Rectangle getClipBounds() {
        Shape shape = this.getClip();
        if (shape == null) {
            return null;
        }
        return shape.getBounds();
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        this.setColor(this.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void rotate(double d) {
        this._transform.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this._transform.rotate(d, d2, d3);
    }

    @Override
    public void shear(double d, double d2) {
        this._transform.shear(d, d2);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean bl = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean bl2 = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), bl, bl2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this._transform.concatenate(affineTransform);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage, n, n2, null);
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this._background = color;
    }

    @Override
    public Color getBackground() {
        return this._background;
    }

    @Override
    public void setComposite(Composite composite) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public Composite getComposite() {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return null;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this._hints.get(key);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this._hints.put(key, object);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.fill(shape);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this._hints.putAll(map);
    }

    @Override
    public void translate(double d, double d2) {
        this._transform.translate(d, d2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.getStroke().createStrokedShape(shape);
        }
        shape = this.getTransform().createTransformedShape(shape);
        return shape.intersects(rectangle);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this._hints;
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this._hints = new RenderingHints(null);
        this._hints.putAll(map);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
        return false;
    }

    @Override
    public Graphics create() {
        try {
            return (Graphics)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new HSLFException(cloneNotSupportedException);
        }
    }

    @Override
    @SuppressForbidden
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public void setXORMode(Color color) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public void setPaintMode() {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        if (this.log.check(5)) {
            this.log.log(5, new Object[]{"Not implemented"});
        }
    }

    protected void applyStroke(HSLFSimpleShape hSLFSimpleShape) {
        if (this._stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this._stroke;
            hSLFSimpleShape.setLineWidth(basicStroke.getLineWidth());
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                hSLFSimpleShape.setLineDashing(StrokeStyle.LineDash.DASH);
            }
        }
    }

    protected void applyPaint(HSLFSimpleShape hSLFSimpleShape) {
        if (this._paint instanceof Color) {
            hSLFSimpleShape.getFill().setForegroundColor((Color)this._paint);
        }
    }
}

