/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.hslf.model.Comment;
import ai2.org.apache.poi.hslf.model.HeadersFooters;
import ai2.org.apache.poi.hslf.model.OLEShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFNotes;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlide;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import ai2.org.apache.poi.hslf.usermodel.HSLFTable;
import ai2.org.apache.poi.hslf.usermodel.HSLFTableCell;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PowerPointExtractor
extends POIOLE2TextExtractor {
    private HSLFSlideShowImpl _hslfshow;
    private HSLFSlideShow _show;
    private List<HSLFSlide> _slides;
    private boolean _slidesByDefault = true;
    private boolean _notesByDefault = false;
    private boolean _commentsByDefault = false;
    private boolean _masterByDefault = false;

    public static void main(String[] stringArray) throws IOException {
        String string;
        if (stringArray.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tPowerPointExtractor [-notes] <file>");
            System.exit(1);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        if (stringArray.length > 1) {
            bl = true;
            string = stringArray[1];
            if (stringArray.length > 2) {
                bl2 = true;
            }
        } else {
            string = stringArray[0];
        }
        PowerPointExtractor powerPointExtractor = new PowerPointExtractor(string);
        System.out.println(powerPointExtractor.getText(true, bl, bl2, bl3));
        powerPointExtractor.close();
    }

    public PowerPointExtractor(String string) throws IOException {
        this(new NPOIFSFileSystem(new File(string)));
    }

    public PowerPointExtractor(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
    }

    public PowerPointExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public PowerPointExtractor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    public PowerPointExtractor(DirectoryNode directoryNode) throws IOException {
        this(new HSLFSlideShowImpl(directoryNode));
    }

    @Deprecated
    public PowerPointExtractor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(new HSLFSlideShowImpl(directoryNode, pOIFSFileSystem));
    }

    public PowerPointExtractor(HSLFSlideShowImpl hSLFSlideShowImpl) {
        super(hSLFSlideShowImpl);
        this._hslfshow = hSLFSlideShowImpl;
        this._show = new HSLFSlideShow(this._hslfshow);
        this._slides = this._show.getSlides();
    }

    public void setSlidesByDefault(boolean bl) {
        this._slidesByDefault = bl;
    }

    public void setNotesByDefault(boolean bl) {
        this._notesByDefault = bl;
    }

    public void setCommentsByDefault(boolean bl) {
        this._commentsByDefault = bl;
    }

    public void setMasterByDefault(boolean bl) {
        this._masterByDefault = bl;
    }

    @Override
    public String getText() {
        return this.getText(this._slidesByDefault, this._notesByDefault, this._commentsByDefault, this._masterByDefault);
    }

    public String getNotes() {
        return this.getText(false, true);
    }

    public List<OLEShape> getOLEShapes() {
        ArrayList<OLEShape> arrayList = new ArrayList<OLEShape>();
        for (HSLFSlide hSLFSlide : this._slides) {
            for (HSLFShape hSLFShape : hSLFSlide.getShapes()) {
                if (!(hSLFShape instanceof OLEShape)) continue;
                arrayList.add((OLEShape)hSLFShape);
            }
        }
        return arrayList;
    }

    public String getText(boolean bl, boolean bl2) {
        return this.getText(bl, bl2, this._commentsByDefault, this._masterByDefault);
    }

    public String getText(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (bl4) {
                for (HSLFSlideMaster object22 : this._show.getSlideMasters()) {
                    for (HSLFShape hSLFShape : object22.getShapes()) {
                        HSLFTextShape hSLFTextShape;
                        String string;
                        if (!(hSLFShape instanceof HSLFTextShape) || HSLFMasterSheet.isPlaceholder(hSLFShape) || (string = (hSLFTextShape = (HSLFTextShape)hSLFShape).getText()) == null) continue;
                        stringBuffer.append(string);
                        if (string.endsWith("\n")) continue;
                        stringBuffer.append("\n");
                    }
                }
            }
            for (int i = 0; i < this._slides.size(); ++i) {
                HSLFSlide hSLFSlide = this._slides.get(i);
                HeadersFooters headersFooters = hSLFSlide.getHeadersFooters();
                if (headersFooters != null && headersFooters.isHeaderVisible() && headersFooters.getHeaderText() != null) {
                    stringBuffer.append(headersFooters.getHeaderText() + "\n");
                }
                this.textRunsToText(stringBuffer, hSLFSlide.getTextParagraphs());
                for (HSLFShape hSLFShape : hSLFSlide.getShapes()) {
                    if (!(hSLFShape instanceof HSLFTable)) continue;
                    this.extractTableText(stringBuffer, (HSLFTable)hSLFShape);
                }
                if (headersFooters != null && headersFooters.isFooterVisible() && headersFooters.getFooterText() != null) {
                    stringBuffer.append(headersFooters.getFooterText() + "\n");
                }
                if (!bl3) continue;
                Comment[] commentArray = hSLFSlide.getComments();
                for (int j = 0; j < commentArray.length; ++j) {
                    stringBuffer.append(commentArray[j].getAuthor() + " - " + commentArray[j].getText() + "\n");
                }
            }
            if (bl2) {
                stringBuffer.append("\n");
            }
        }
        if (bl2) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HeadersFooters headersFooters = this._show.getNotesHeadersFooters();
            for (int i = 0; i < this._slides.size(); ++i) {
                Integer n;
                HSLFNotes hSLFNotes = this._slides.get(i).getNotes();
                if (hSLFNotes == null || hashSet.contains(n = Integer.valueOf(hSLFNotes._getSheetNumber()))) continue;
                hashSet.add(n);
                if (headersFooters != null && headersFooters.isHeaderVisible() && headersFooters.getHeaderText() != null) {
                    stringBuffer.append(headersFooters.getHeaderText() + "\n");
                }
                this.textRunsToText(stringBuffer, hSLFNotes.getTextParagraphs());
                if (headersFooters == null || !headersFooters.isFooterVisible() || headersFooters.getFooterText() == null) continue;
                stringBuffer.append(headersFooters.getFooterText() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private void extractTableText(StringBuffer stringBuffer, HSLFTable hSLFTable) {
        for (int i = 0; i < hSLFTable.getNumberOfRows(); ++i) {
            for (int j = 0; j < hSLFTable.getNumberOfColumns(); ++j) {
                HSLFTableCell hSLFTableCell = hSLFTable.getCell(i, j);
                if (hSLFTableCell == null) continue;
                String string = hSLFTableCell.getText();
                string = string == null ? "" : string;
                stringBuffer.append(string);
                if (j >= hSLFTable.getNumberOfColumns() - 1) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append('\n');
        }
    }

    private void textRunsToText(StringBuffer stringBuffer, List<List<HSLFTextParagraph>> list) {
        if (list == null) {
            return;
        }
        for (List<HSLFTextParagraph> list2 : list) {
            stringBuffer.append(HSLFTextParagraph.getText(list2));
            if (stringBuffer.length() <= 0 || stringBuffer.charAt(stringBuffer.length() - 1) == '\n') continue;
            stringBuffer.append("\n");
        }
    }
}

