/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class SlideShowDumper {
    private NPOIFSFileSystem filesystem;
    private byte[] _docstream;
    private boolean ddfEscher = false;
    private boolean basicEscher = false;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Useage: SlideShowDumper [-escher|-basicescher] <filename>");
            return;
        }
        String string = stringArray[0];
        if (stringArray.length > 1) {
            string = stringArray[1];
        }
        SlideShowDumper slideShowDumper = new SlideShowDumper(string);
        if (stringArray.length > 1) {
            if (stringArray[0].equalsIgnoreCase("-escher")) {
                slideShowDumper.setDDFEscher(true);
            } else {
                slideShowDumper.setBasicEscher(true);
            }
        }
        slideShowDumper.printDump();
        slideShowDumper.close();
    }

    public SlideShowDumper(String string) throws IOException {
        this(new NPOIFSFileSystem(new File(string)));
    }

    public SlideShowDumper(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    public SlideShowDumper(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this.filesystem = nPOIFSFileSystem;
        DocumentEntry documentEntry = (DocumentEntry)nPOIFSFileSystem.getRoot().getEntry("PowerPoint Document");
        this._docstream = new byte[documentEntry.getSize()];
        nPOIFSFileSystem.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    public void setDDFEscher(boolean bl) {
        this.ddfEscher = bl;
        this.basicEscher = !bl;
    }

    public void setBasicEscher(boolean bl) {
        this.basicEscher = bl;
        this.ddfEscher = !bl;
    }

    public void close() throws IOException {
        this.filesystem.close();
    }

    public void printDump() {
        this.walkTree(0, 0, this._docstream.length);
    }

    public String makeHex(short s) {
        String string = Integer.toHexString(s).toUpperCase(Locale.ROOT);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public String makeHex(int n) {
        String string = Integer.toHexString(n).toUpperCase(Locale.ROOT);
        if (string.length() == 1) {
            return "000" + string;
        }
        if (string.length() == 2) {
            return "00" + string;
        }
        if (string.length() == 3) {
            return "0" + string;
        }
        return string;
    }

    public void walkTree(int n, int n2, int n3) {
        long l;
        int n4 = n2 + n3;
        int n5 = n;
        for (int i = n2; i <= n4 - 8; i += (int)l) {
            long l2 = LittleEndian.getUShort(this._docstream, i + 2);
            l = LittleEndian.getUInt(this._docstream, i + 4);
            byte by = this._docstream[i];
            String string = "";
            for (int j = 0; j < n5; ++j) {
                string = string + " ";
            }
            System.out.println(string + "At position " + i + " (" + this.makeHex(i) + "):");
            System.out.println(string + "Type is " + l2 + " (" + this.makeHex((int)l2) + "), len is " + l + " (" + this.makeHex((int)l) + ")");
            String string2 = RecordTypes.recordName((int)l2);
            i += 8;
            if (string2 != null) {
                System.out.println(string + "That's a " + string2);
                int n6 = by & 0xF;
                if (l2 == 5003L && (long)by == 0L) {
                    n6 = 15;
                }
                if (l2 == 0L || n6 != 15) {
                    System.out.println();
                    continue;
                }
                if (l2 == 1035L || l2 == 1036L) {
                    System.out.println();
                    if (this.ddfEscher) {
                        this.walkEscherDDF(n5 + 3, i + 8, (int)l - 8);
                        continue;
                    }
                    if (!this.basicEscher) continue;
                    this.walkEscherBasic(n5 + 3, i + 8, (int)l - 8);
                    continue;
                }
                System.out.println();
                this.walkTree(n5 + 2, i, (int)l);
                continue;
            }
            System.out.println(string + "** unknown record **");
            System.out.println();
        }
    }

    public void walkEscherDDF(int n, int n2, int n3) {
        if (n3 < 8) {
            return;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this._docstream, n2, byArray, 0, n3);
        HSLFEscherRecordFactory hSLFEscherRecordFactory = new HSLFEscherRecordFactory();
        EscherRecord escherRecord = ((DefaultEscherRecordFactory)hSLFEscherRecordFactory).createRecord(byArray, 0);
        escherRecord.fillFields(byArray, 0, hSLFEscherRecordFactory);
        long l = LittleEndian.getUShort(byArray, 2);
        long l2 = LittleEndian.getUShort(byArray, 4);
        int n4 = escherRecord.getRecordSize();
        System.out.println(string + "At position " + n2 + " (" + this.makeHex(n2) + "):");
        System.out.println(string + "Type is " + l + " (" + this.makeHex((int)l) + "), len is " + l2 + " (" + this.makeHex((int)l2) + ") (" + (l2 + 8L) + ") - record claims " + n4);
        if (n4 != 8 && (long)n4 != l2 + 8L) {
            System.out.println(string + "** Atom length of " + l2 + " (" + (l2 + 8L) + ") doesn't match record length of " + n4);
        }
        if (escherRecord instanceof EscherContainerRecord) {
            EscherContainerRecord escherContainerRecord = (EscherContainerRecord)escherRecord;
            System.out.println(string + escherContainerRecord.toString());
            this.walkEscherDDF(n + 3, n2 + 8, (int)l2);
        } else {
            System.out.println(string + escherRecord.toString());
        }
        if (l == 61451L) {
            n4 = (int)l2 + 8;
        }
        if (l == 61453L) {
            n4 = (int)l2 + 8;
            escherRecord.fillFields(byArray, 0, hSLFEscherRecordFactory);
            if (!(escherRecord instanceof EscherTextboxRecord)) {
                System.out.println(string + "** Really a msofbtClientTextbox !");
            }
        }
        if (n4 == 8 && l2 > 8L) {
            this.walkEscherDDF(n + 3, n2 + 8, (int)l2);
            n2 = (int)((long)n2 + l2);
            n2 += 8;
            n3 = (int)((long)n3 - l2);
            n3 -= 8;
        } else {
            n2 = (int)((long)n2 + l2);
            n2 += 8;
            n3 = (int)((long)n3 - l2);
            n3 -= 8;
        }
        if (n3 >= 8) {
            this.walkEscherDDF(n, n2, n3);
        }
    }

    public void walkEscherBasic(int n, int n2, int n3) {
        int n4;
        if (n3 < 8) {
            return;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        long l = LittleEndian.getUShort(this._docstream, n2 + 2);
        long l2 = LittleEndian.getUInt(this._docstream, n2 + 4);
        String string2 = this.makeHex((int)l);
        System.out.println(string + "At position " + n2 + " (" + this.makeHex(n2) + "):");
        System.out.println(string + "Type is " + l + " (" + string2 + "), len is " + l2 + " (" + this.makeHex((int)l2) + ")");
        String string3 = RecordTypes.recordName((int)l);
        if (string3 != null) {
            System.out.println(string + "That's an Escher Record: " + string3);
        } else {
            System.out.println(string + "(Unknown Escher Record)");
        }
        if (l == 61453L) {
            short s;
            System.out.print(string);
            for (n4 = 8; n4 < 16; ++n4) {
                s = this._docstream[n4 + n2];
                if (s < 0) {
                    s = (short)(s + 256);
                }
                System.out.print(n4 + "=" + s + " (" + this.makeHex(s) + ")  ");
            }
            System.out.println("");
            System.out.print(string);
            for (n4 = 20; n4 < 28; ++n4) {
                s = this._docstream[n4 + n2];
                if (s < 0) {
                    s = (short)(s + 256);
                }
                System.out.print(n4 + "=" + s + " (" + this.makeHex(s) + ")  ");
            }
            System.out.println("");
        }
        System.out.println("");
        if (l == 61443L || l == 61444L) {
            this.walkEscherBasic(n + 3, n2 + 8, (int)l2);
        }
        if (l2 < (long)n3) {
            n4 = (int)l2;
            this.walkEscherBasic(n, n2 + n4 + 8, n3 - n4 - 8);
        }
    }
}

