/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.Notes;
import ai2.org.apache.poi.hslf.record.NotesAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.SheetContainer;
import ai2.org.apache.poi.hslf.record.Slide;
import ai2.org.apache.poi.hslf.record.SlideAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;

public final class SlideAndNotesAtomListing {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        System.out.println("");
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        for (int i = 0; i < recordArray.length; ++i) {
            RecordAtom recordAtom;
            SheetContainer sheetContainer;
            Record record = recordArray[i];
            if (record instanceof Slide) {
                sheetContainer = (Slide)record;
                recordAtom = ((Slide)sheetContainer).getSlideAtom();
                System.out.println("Found Slide at " + i);
                System.out.println("  Slide's master ID is " + ((SlideAtom)recordAtom).getMasterID());
                System.out.println("  Slide's notes ID is  " + ((SlideAtom)recordAtom).getNotesID());
                System.out.println("");
            }
            if (!(record instanceof Notes)) continue;
            sheetContainer = (Notes)record;
            recordAtom = ((Notes)sheetContainer).getNotesAtom();
            System.out.println("Found Notes at " + i);
            System.out.println("  Notes ID is " + ((NotesAtom)recordAtom).getSlideID());
            System.out.println("");
        }
    }
}

