/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public final class PPTXMLDump {
    public static final int HEADER_SIZE = 8;
    public static final int PICT_HEADER_SIZE = 25;
    public static final String PPDOC_ENTRY = "PowerPoint Document";
    public static final String PICTURES_ENTRY = "Pictures";
    public static final String CR = System.getProperty("line.separator");
    protected Writer out;
    protected byte[] docstream;
    protected byte[] pictstream;
    protected boolean hexHeader = true;
    private static final byte[] hexval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PPTXMLDump(File file) throws IOException {
        NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(file, true);
        DocumentInputStream documentInputStream = null;
        try {
            DocumentEntry documentEntry = (DocumentEntry)nPOIFSFileSystem.getRoot().getEntry(PPDOC_ENTRY);
            this.docstream = new byte[documentEntry.getSize()];
            documentInputStream = nPOIFSFileSystem.createDocumentInputStream(PPDOC_ENTRY);
            documentInputStream.read(this.docstream);
            documentInputStream.close();
            documentEntry = (DocumentEntry)nPOIFSFileSystem.getRoot().getEntry(PICTURES_ENTRY);
            this.pictstream = new byte[documentEntry.getSize()];
            documentInputStream = nPOIFSFileSystem.createDocumentInputStream(PICTURES_ENTRY);
            documentInputStream.read(this.pictstream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (documentInputStream != null) {
                documentInputStream.close();
            }
            nPOIFSFileSystem.close();
        }
    }

    public void dump(Writer writer) throws IOException {
        this.out = writer;
        int n = 0;
        PPTXMLDump.write(this.out, "<Presentation>" + CR, n);
        ++n;
        if (this.pictstream != null) {
            PPTXMLDump.write(this.out, "<Pictures>" + CR, n);
            this.dumpPictures(this.pictstream, n);
            PPTXMLDump.write(this.out, "</Pictures>" + CR, n);
        }
        PPTXMLDump.write(this.out, "<PowerPointDocument>" + CR, n);
        this.dump(this.docstream, 0, this.docstream.length, ++n);
        PPTXMLDump.write(this.out, "</PowerPointDocument>" + CR, --n);
        PPTXMLDump.write(this.out, "</Presentation>", --n);
    }

    public void dump(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        for (int i = n; i <= n + n2 - 8 && i >= 0; i += n4) {
            boolean bl;
            int n5 = LittleEndian.getUShort(byArray, i);
            int n6 = LittleEndian.getUShort(byArray, i += 2);
            n4 = (int)LittleEndian.getUInt(byArray, i += 2);
            String string = RecordTypes.recordName(n6);
            PPTXMLDump.write(this.out, "<" + string + " info=\"" + n5 + "\" type=\"" + n6 + "\" size=\"" + n4 + "\" offset=\"" + ((i += 4) - 8) + "\"", n3);
            if (this.hexHeader) {
                this.out.write(" header=\"");
                PPTXMLDump.dump(this.out, byArray, i - 8, 8, 0, false);
                this.out.write("\"");
            }
            this.out.write(">" + CR);
            ++n3;
            boolean bl2 = bl = (n5 & 0xF) == 15;
            if (bl) {
                this.dump(byArray, i, n4, n3);
            } else {
                PPTXMLDump.dump(this.out, byArray, i, Math.min(n4, byArray.length - i), n3, true);
            }
            PPTXMLDump.write(this.out, "</" + string + ">" + CR, --n3);
        }
    }

    public void dumpPictures(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < byArray.length) {
            byte[] byArray2 = new byte[25];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            int n3 = LittleEndian.getInt(byArray2, 4) - 17;
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2 + 25, byArray3, 0, byArray3.length);
            n2 += 25 + n3;
            PPTXMLDump.write(this.out, "<picture size=\"" + n3 + "\" type=\"" + this.getPictureType(byArray2) + "\">" + CR, ++n);
            PPTXMLDump.write(this.out, "<header>" + CR, ++n);
            PPTXMLDump.dump(this.out, byArray2, 0, byArray2.length, n, true);
            PPTXMLDump.write(this.out, "</header>" + CR, n);
            PPTXMLDump.write(this.out, "<imgdata>" + CR, n);
            PPTXMLDump.dump(this.out, byArray3, 0, Math.min(byArray3.length, 100), n, true);
            PPTXMLDump.write(this.out, "</imgdata>" + CR, n);
            PPTXMLDump.write(this.out, "</picture>" + CR, --n);
            --n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Usage: PPTXMLDump (options) pptfile\nWhere options include:\n    -f     write output to <pptfile>.xml file in the current directory");
            return;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Closeable closeable;
            if (stringArray[i].startsWith("-")) {
                if (!"-f".equals(stringArray[i])) continue;
                bl = true;
                continue;
            }
            File file = new File(stringArray[i]);
            PPTXMLDump pPTXMLDump = new PPTXMLDump(file);
            System.out.println("Dumping " + stringArray[i]);
            if (bl) {
                closeable = new FileOutputStream(file.getName() + ".xml");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)closeable, Charset.forName("UTF8"));
                pPTXMLDump.dump(outputStreamWriter);
                outputStreamWriter.close();
                continue;
            }
            closeable = new StringWriter();
            pPTXMLDump.dump((Writer)closeable);
            System.out.println(closeable.toString());
        }
    }

    private static void write(Writer writer, String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write("  ");
        }
        writer.write(string);
    }

    private String getPictureType(byte[] byArray) {
        String string;
        int n = LittleEndian.getUShort(byArray, 0);
        switch (n) {
            case 18080: {
                string = "jpeg";
                break;
            }
            case 8544: {
                string = "wmf";
                break;
            }
            case 28160: {
                string = "png";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    private static void dump(Writer writer, byte[] byArray, int n, int n2, int n3, boolean bl) throws IOException {
        int n4;
        int n5 = 25;
        for (n4 = 0; n4 < n3; ++n4) {
            writer.write("  ");
        }
        for (n4 = n; n4 < n + n2; ++n4) {
            byte by = byArray[n4];
            writer.write((char)hexval[(by & 0xF0) >> 4]);
            writer.write((char)hexval[(by & 0xF) >> 0]);
            writer.write(32);
            if ((n4 + 1 - n) % n5 != 0 || n4 == n + n2 - 1) continue;
            writer.write(CR);
            for (int i = 0; i < n3; ++i) {
                writer.write("  ");
            }
        }
        if (bl && n2 > 0) {
            writer.write(CR);
        }
    }
}

