/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.blip.Metafile;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;

public final class WMF
extends Metafile {
    public byte[] getData() {
        try {
            int n;
            byte[] byArray = this.getRawData();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Metafile.Header header = new Metafile.Header();
            header.read(byArray, 16 * this.uidInstanceCount);
            ((InputStream)byteArrayInputStream).skip(header.getSize() + 16 * this.uidInstanceCount);
            NativeHeader nativeHeader = new NativeHeader(header.bounds);
            nativeHeader.write(byteArrayOutputStream);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[4096];
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new HSLFException(iOException);
        }
    }

    public void setData(byte[] byArray) throws IOException {
        int n = 0;
        NativeHeader nativeHeader = new NativeHeader(byArray, n);
        byte[] byArray2 = WMF.compress(byArray, n += nativeHeader.getLength(), byArray.length - n);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = byArray.length - nativeHeader.getLength();
        header.bounds = new Rectangle((short)nativeHeader.left, (short)nativeHeader.top, (short)nativeHeader.right - (short)nativeHeader.left, (short)nativeHeader.bottom - (short)nativeHeader.top);
        Dimension dimension = nativeHeader.getSize();
        header.size = new Dimension(Units.toEMU(dimension.getWidth()), Units.toEMU(dimension.getHeight()));
        header.zipsize = byArray2.length;
        byte[] byArray3 = WMF.getChecksum(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < this.uidInstanceCount; ++i) {
            byteArrayOutputStream.write(byArray3);
        }
        header.write(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        this.setRawData(byteArrayOutputStream.toByteArray());
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.WMF;
    }

    public int getSignature() {
        return this.uidInstanceCount == 1 ? 8544 : 8560;
    }

    public void setSignature(int n) {
        switch (n) {
            case 8544: {
                this.uidInstanceCount = 1;
                break;
            }
            case 8560: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid instance/signature value for WMF");
            }
        }
    }

    public static class NativeHeader {
        public static final int APMHEADER_KEY = -1698247209;
        private static POILogger logger = POILogFactory.getLogger(NativeHeader.class);
        private final int handle;
        private final int left;
        private final int top;
        private final int right;
        private final int bottom;
        private final int inch;
        private final int reserved;
        private int checksum;

        public NativeHeader(Rectangle rectangle) {
            this.handle = 0;
            this.left = rectangle.x;
            this.top = rectangle.y;
            this.right = rectangle.x + rectangle.width;
            this.bottom = rectangle.y + rectangle.height;
            this.inch = 72;
            this.reserved = 0;
        }

        public NativeHeader(byte[] byArray, int n) {
            int n2 = LittleEndian.getInt(byArray, n);
            n += 4;
            if (n2 != -1698247209) {
                logger.log(5, new Object[]{"WMF file doesn't contain a placeable header - ignore parsing"});
                this.handle = 0;
                this.left = 0;
                this.top = 0;
                this.right = 200;
                this.bottom = 200;
                this.inch = 72;
                this.reserved = 0;
                return;
            }
            this.handle = LittleEndian.getUShort(byArray, n);
            this.left = LittleEndian.getShort(byArray, n += 2);
            this.top = LittleEndian.getShort(byArray, n += 2);
            this.right = LittleEndian.getShort(byArray, n += 2);
            this.bottom = LittleEndian.getShort(byArray, n += 2);
            this.inch = LittleEndian.getUShort(byArray, n += 2);
            this.reserved = LittleEndian.getInt(byArray, n += 2);
            this.checksum = LittleEndian.getShort(byArray, n += 4);
            n += 2;
            if (this.checksum != this.getChecksum()) {
                logger.log(5, new Object[]{"WMF checksum does not match the header data"});
            }
        }

        public int getChecksum() {
            int n = 0;
            n ^= 0xCDD7;
            n ^= 0xFFFF9AC6;
            n ^= this.left;
            n ^= this.top;
            n ^= this.right;
            n ^= this.bottom;
            return n ^= this.inch;
        }

        public void write(OutputStream outputStream) throws IOException {
            byte[] byArray = new byte[22];
            int n = 0;
            LittleEndian.putInt(byArray, n, -1698247209);
            LittleEndian.putUShort(byArray, n += 4, 0);
            LittleEndian.putUShort(byArray, n += 2, this.left);
            LittleEndian.putUShort(byArray, n += 2, this.top);
            LittleEndian.putUShort(byArray, n += 2, this.right);
            LittleEndian.putUShort(byArray, n += 2, this.bottom);
            LittleEndian.putUShort(byArray, n += 2, this.inch);
            LittleEndian.putInt(byArray, n += 2, 0);
            this.checksum = this.getChecksum();
            LittleEndian.putUShort(byArray, n += 4, this.checksum);
            outputStream.write(byArray);
        }

        public Dimension getSize() {
            double d = 72.0 / (double)this.inch;
            return new Dimension((int)Math.round((double)(this.right - this.left) * d), (int)Math.round((double)(this.bottom - this.top) * d));
        }

        public int getLength() {
            return 22;
        }
    }
}

