/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.blip.Bitmap;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.PngUtils;

public final class PNG
extends Bitmap {
    public byte[] getData() {
        byte[] byArray = super.getData();
        if (PngUtils.matchesPngHeader(byArray, 16)) {
            byte[] byArray2 = new byte[byArray.length - 16];
            System.arraycopy(byArray, 16, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.PNG;
    }

    public int getSignature() {
        return this.uidInstanceCount == 1 ? 28160 : 28176;
    }

    public void setSignature(int n) {
        switch (n) {
            case 28160: {
                this.uidInstanceCount = 1;
                break;
            }
            case 28176: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid instance/signature value for PNG");
            }
        }
    }
}

