/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.blip.Metafile;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public final class PICT
extends Metafile {
    public byte[] getData() {
        byte[] byArray = this.getRawData();
        try {
            byte[] byArray2 = new byte[512];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray2);
            int n = 16 * this.uidInstanceCount;
            byte[] byArray3 = this.read(byArray, n);
            byteArrayOutputStream.write(byArray3);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new HSLFException(iOException);
        }
    }

    private byte[] read(byte[] byArray, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Metafile.Header header = new Metafile.Header();
        header.read(byArray, n);
        byteArrayInputStream.skip(n + header.getSize());
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[4096];
        while ((n2 = inflaterInputStream.read(byArray2)) >= 0) {
            byteArrayOutputStream.write(byArray2, 0, n2);
        }
        inflaterInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void setData(byte[] byArray) throws IOException {
        NativeHeader nativeHeader = new NativeHeader(byArray, 512);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = byArray.length - 512;
        byte[] byArray2 = PICT.compress(byArray, 512, header.wmfsize);
        header.zipsize = byArray2.length;
        header.bounds = nativeHeader.bounds;
        Dimension dimension = nativeHeader.getSize();
        header.size = new Dimension(Units.toEMU(dimension.getWidth()), Units.toEMU(dimension.getHeight()));
        byte[] byArray3 = PICT.getChecksum(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray3);
        if (this.uidInstanceCount == 2) {
            byteArrayOutputStream.write(byArray3);
        }
        header.write(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        this.setRawData(byteArrayOutputStream.toByteArray());
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.PICT;
    }

    public int getSignature() {
        return this.uidInstanceCount == 1 ? 21536 : 21552;
    }

    public void setSignature(int n) {
        switch (n) {
            case 21536: {
                this.uidInstanceCount = 1;
                break;
            }
            case 21552: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid instance/signature value for PICT");
            }
        }
    }

    public static class NativeHeader {
        public static final int PICT_HEADER_OFFSET = 512;
        public static final double DEFAULT_RESOLUTION = 72.0;
        private static final byte[] V2_HEADER = new byte[]{0, 17, 2, -1, 12, 0, -1, -2, 0, 0};
        public final Rectangle bounds;
        public final double hRes;
        public final double vRes;

        public NativeHeader(byte[] byArray, int n) {
            int n2 = NativeHeader.readUnsignedShort(byArray, n += 2);
            int n3 = NativeHeader.readUnsignedShort(byArray, n += 2);
            int n4 = NativeHeader.readUnsignedShort(byArray, n += 2);
            int n5 = NativeHeader.readUnsignedShort(byArray, n += 2);
            n += 2;
            boolean bl = true;
            for (byte by : V2_HEADER) {
                if (by == byArray[n++]) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.hRes = NativeHeader.readFixedPoint(byArray, n);
                this.vRes = NativeHeader.readFixedPoint(byArray, n += 4);
                n += 4;
            } else {
                this.hRes = 72.0;
                this.vRes = 72.0;
            }
            this.bounds = new Rectangle(n3, n2, n5 - n3, n4 - n2);
        }

        public Dimension getSize() {
            int n = (int)Math.round((double)this.bounds.height * 72.0 / this.vRes);
            int n2 = (int)Math.round((double)this.bounds.width * 72.0 / this.hRes);
            return new Dimension(n2, n);
        }

        private static int readUnsignedShort(byte[] byArray, int n) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray[n + 1] & 0xFF;
            return n2 << 8 | n3;
        }

        private static double readFixedPoint(byte[] byArray, int n) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray[n + 1] & 0xFF;
            int n4 = byArray[n + 2] & 0xFF;
            int n5 = byArray[n + 3] & 0xFF;
            int n6 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
            return (double)n6 / 65536.0;
        }
    }
}

