/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.blip.Bitmap;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;

public final class DIB
extends Bitmap {
    private static final int HEADER_SIZE = 14;

    public PictureData.PictureType getType() {
        return PictureData.PictureType.DIB;
    }

    public int getSignature() {
        return this.uidInstanceCount == 1 ? 31360 : 31376;
    }

    public void setSignature(int n) {
        switch (n) {
            case 31360: {
                this.uidInstanceCount = 1;
                break;
            }
            case 31376: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid instance/signature value for DIB");
            }
        }
    }

    public byte[] getData() {
        return DIB.addBMPHeader(super.getData());
    }

    public static byte[] addBMPHeader(byte[] byArray) {
        byte[] byArray2 = new byte[14];
        LittleEndian.putInt(byArray2, 0, 19778);
        int n = LittleEndian.getInt(byArray, 20);
        int n2 = byArray.length + 14;
        int n3 = n2 - n;
        LittleEndian.putInt(byArray2, 2, n2);
        LittleEndian.putInt(byArray2, 6, 0);
        LittleEndian.putInt(byArray2, 10, n3);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    public void setData(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length - 14];
        System.arraycopy(byArray, 14, byArray2, 0, byArray2.length);
        super.setData(byArray2);
    }
}

