/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.ClassID;
import ai2.org.apache.poi.hpsf.IllegalPropertySetDataException;
import ai2.org.apache.poi.hpsf.Property;
import ai2.org.apache.poi.hpsf.UnsupportedVariantTypeException;
import ai2.org.apache.poi.hpsf.VariantSupport;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class TypeWriter {
    public static int writeToStream(OutputStream outputStream, short s) throws IOException {
        LittleEndian.putShort(outputStream, s);
        return 2;
    }

    public static int writeToStream(OutputStream outputStream, int n) throws IOException {
        LittleEndian.putInt(n, outputStream);
        return 4;
    }

    public static int writeToStream(OutputStream outputStream, long l) throws IOException {
        LittleEndian.putLong(l, outputStream);
        return 8;
    }

    public static void writeUShortToStream(OutputStream outputStream, int n) throws IOException {
        int n2 = n & 0xFFFF0000;
        if (n2 != 0) {
            throw new IllegalPropertySetDataException("Value " + n + " cannot be represented by 2 bytes.");
        }
        LittleEndian.putUShort(n, outputStream);
    }

    public static int writeUIntToStream(OutputStream outputStream, long l) throws IOException {
        long l2 = l & 0xFFFFFFFF00000000L;
        if (l2 != 0L && l2 != -4294967296L) {
            throw new IllegalPropertySetDataException("Value " + l + " cannot be represented by 4 bytes.");
        }
        LittleEndian.putUInt(l, outputStream);
        return 4;
    }

    public static int writeToStream(OutputStream outputStream, ClassID classID) throws IOException {
        byte[] byArray = new byte[16];
        classID.write(byArray, 0);
        outputStream.write(byArray, 0, byArray.length);
        return byArray.length;
    }

    public static void writeToStream(OutputStream outputStream, Property[] propertyArray, int n) throws IOException, UnsupportedVariantTypeException {
        Property property;
        int n2;
        if (propertyArray == null) {
            return;
        }
        for (n2 = 0; n2 < propertyArray.length; ++n2) {
            property = propertyArray[n2];
            TypeWriter.writeUIntToStream(outputStream, property.getID());
            TypeWriter.writeUIntToStream(outputStream, property.getSize());
        }
        for (n2 = 0; n2 < propertyArray.length; ++n2) {
            property = propertyArray[n2];
            long l = property.getType();
            TypeWriter.writeUIntToStream(outputStream, l);
            VariantSupport.write(outputStream, (int)l, property.getValue(), n);
        }
    }

    public static int writeToStream(OutputStream outputStream, double d) throws IOException {
        LittleEndian.putDouble(d, outputStream);
        return 8;
    }
}

