/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.ClassID;
import ai2.org.apache.poi.hpsf.MutablePropertySet;
import ai2.org.apache.poi.hpsf.NoSingleSectionException;
import ai2.org.apache.poi.hpsf.Property;
import ai2.org.apache.poi.hpsf.PropertySet;
import ai2.org.apache.poi.hpsf.Section;
import ai2.org.apache.poi.hpsf.WritingNotSupportedException;
import ai2.org.apache.poi.hpsf.wellknown.PropertyIDMap;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecialPropertySet
extends MutablePropertySet {
    private MutablePropertySet delegate;

    public abstract PropertyIDMap getPropertySetIDMap();

    public SpecialPropertySet(PropertySet propertySet) {
        this.delegate = new MutablePropertySet(propertySet);
    }

    public SpecialPropertySet(MutablePropertySet mutablePropertySet) {
        this.delegate = mutablePropertySet;
    }

    @Override
    public int getByteOrder() {
        return this.delegate.getByteOrder();
    }

    @Override
    public int getFormat() {
        return this.delegate.getFormat();
    }

    @Override
    public int getOSVersion() {
        return this.delegate.getOSVersion();
    }

    @Override
    public ClassID getClassID() {
        return this.delegate.getClassID();
    }

    @Override
    public int getSectionCount() {
        return this.delegate.getSectionCount();
    }

    @Override
    public List<Section> getSections() {
        return this.delegate.getSections();
    }

    @Override
    public boolean isSummaryInformation() {
        return this.delegate.isSummaryInformation();
    }

    @Override
    public boolean isDocumentSummaryInformation() {
        return this.delegate.isDocumentSummaryInformation();
    }

    @Override
    public Section getFirstSection() {
        return this.delegate.getFirstSection();
    }

    @Override
    public void addSection(Section section) {
        this.delegate.addSection(section);
    }

    @Override
    public void clearSections() {
        this.delegate.clearSections();
    }

    @Override
    public void setByteOrder(int n) {
        this.delegate.setByteOrder(n);
    }

    @Override
    public void setClassID(ClassID classID) {
        this.delegate.setClassID(classID);
    }

    @Override
    public void setFormat(int n) {
        this.delegate.setFormat(n);
    }

    @Override
    public void setOSVersion(int n) {
        this.delegate.setOSVersion(n);
    }

    @Override
    public InputStream toInputStream() throws IOException, WritingNotSupportedException {
        return this.delegate.toInputStream();
    }

    @Override
    public void write(DirectoryEntry directoryEntry, String string) throws WritingNotSupportedException, IOException {
        this.delegate.write(directoryEntry, string);
    }

    @Override
    public void write(OutputStream outputStream) throws WritingNotSupportedException, IOException {
        this.delegate.write(outputStream);
    }

    @Override
    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public Property[] getProperties() throws NoSingleSectionException {
        return this.delegate.getProperties();
    }

    @Override
    protected Object getProperty(int n) throws NoSingleSectionException {
        return this.delegate.getProperty(n);
    }

    @Override
    protected boolean getPropertyBooleanValue(int n) throws NoSingleSectionException {
        return this.delegate.getPropertyBooleanValue(n);
    }

    @Override
    protected int getPropertyIntValue(int n) throws NoSingleSectionException {
        return this.delegate.getPropertyIntValue(n);
    }

    protected String getPropertyStringValue(int n) {
        Object object = this.getProperty(n);
        return SpecialPropertySet.getPropertyStringValue(object);
    }

    protected static String getPropertyStringValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return "";
            }
            if (byArray.length == 1) {
                return Byte.toString(byArray[0]);
            }
            if (byArray.length == 2) {
                return Integer.toString(LittleEndian.getUShort(byArray));
            }
            if (byArray.length == 4) {
                return Long.toString(LittleEndian.getUInt(byArray));
            }
            return new String(byArray, Charset.forName("ASCII"));
        }
        return object.toString();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean wasNull() throws NoSingleSectionException {
        return this.delegate.wasNull();
    }
}

