/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.ClassID;
import ai2.org.apache.poi.hpsf.HPSFRuntimeException;
import ai2.org.apache.poi.hpsf.IllegalPropertySetDataException;
import ai2.org.apache.poi.hpsf.MutableSection;
import ai2.org.apache.poi.hpsf.NoFormatIDException;
import ai2.org.apache.poi.hpsf.PropertySet;
import ai2.org.apache.poi.hpsf.Section;
import ai2.org.apache.poi.hpsf.TypeWriter;
import ai2.org.apache.poi.hpsf.WritingNotSupportedException;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public class MutablePropertySet
extends PropertySet {
    private final int OFFSET_HEADER = BYTE_ORDER_ASSERTION.length + FORMAT_ASSERTION.length + 4 + 16 + 4;

    public MutablePropertySet() {
        this.byteOrder = LittleEndian.getUShort(BYTE_ORDER_ASSERTION);
        this.format = LittleEndian.getUShort(FORMAT_ASSERTION);
        this.osVersion = 133636;
        this.classID = new ClassID();
        this.sections = new LinkedList();
        this.sections.add(new MutableSection());
    }

    public MutablePropertySet(PropertySet propertySet) {
        this.byteOrder = propertySet.getByteOrder();
        this.format = propertySet.getFormat();
        this.osVersion = propertySet.getOSVersion();
        this.setClassID(propertySet.getClassID());
        this.clearSections();
        if (this.sections == null) {
            this.sections = new LinkedList();
        }
        for (Section section : propertySet.getSections()) {
            MutableSection mutableSection = new MutableSection(section);
            this.addSection(mutableSection);
        }
    }

    public void setByteOrder(int n) {
        this.byteOrder = n;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public void setOSVersion(int n) {
        this.osVersion = n;
    }

    public void setClassID(ClassID classID) {
        this.classID = classID;
    }

    public void clearSections() {
        this.sections = null;
    }

    public void addSection(Section section) {
        if (this.sections == null) {
            this.sections = new LinkedList();
        }
        this.sections.add(section);
    }

    public void write(OutputStream outputStream) throws WritingNotSupportedException, IOException {
        MutableSection mutableSection;
        int n = this.sections.size();
        int n2 = 0;
        n2 += TypeWriter.writeToStream(outputStream, (short)this.getByteOrder());
        n2 += TypeWriter.writeToStream(outputStream, (short)this.getFormat());
        n2 += TypeWriter.writeToStream(outputStream, this.getOSVersion());
        n2 += TypeWriter.writeToStream(outputStream, this.getClassID());
        n2 += TypeWriter.writeToStream(outputStream, n);
        int n3 = this.OFFSET_HEADER;
        int n4 = n3 += n * 20;
        for (Section section : this.sections) {
            mutableSection = (MutableSection)section;
            ClassID classID = mutableSection.getFormatID();
            if (classID == null) {
                throw new NoFormatIDException();
            }
            n2 += TypeWriter.writeToStream(outputStream, mutableSection.getFormatID());
            n2 += TypeWriter.writeUIntToStream(outputStream, n3);
            try {
                n3 += mutableSection.getSize();
            }
            catch (HPSFRuntimeException hPSFRuntimeException) {
                Throwable throwable = hPSFRuntimeException.getReason();
                if (throwable instanceof UnsupportedEncodingException) {
                    throw new IllegalPropertySetDataException(throwable);
                }
                throw hPSFRuntimeException;
            }
        }
        n3 = n4;
        for (Section section : this.sections) {
            mutableSection = (MutableSection)section;
            n3 += mutableSection.write(outputStream);
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toInputStream() throws IOException, WritingNotSupportedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.write(byteArrayOutputStream);
        }
        finally {
            byteArrayOutputStream.close();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray);
    }

    public void write(DirectoryEntry directoryEntry, String string) throws WritingNotSupportedException, IOException {
        try {
            Entry entry = directoryEntry.getEntry(string);
            entry.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        directoryEntry.createDocument(string, this.toInputStream());
    }
}

