/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

class Filetime {
    static final int SIZE = 8;
    private int _dwHighDateTime;
    private int _dwLowDateTime;

    Filetime(byte[] byArray, int n) {
        this._dwLowDateTime = LittleEndian.getInt(byArray, n + 0);
        this._dwHighDateTime = LittleEndian.getInt(byArray, n + 4);
    }

    Filetime(int n, int n2) {
        this._dwLowDateTime = n;
        this._dwHighDateTime = n2;
    }

    long getHigh() {
        return this._dwHighDateTime;
    }

    long getLow() {
        return this._dwLowDateTime;
    }

    byte[] toByteArray() {
        byte[] byArray = new byte[8];
        LittleEndian.putInt(byArray, 0, this._dwLowDateTime);
        LittleEndian.putInt(byArray, 4, this._dwHighDateTime);
        return byArray;
    }

    int write(OutputStream outputStream) throws IOException {
        LittleEndian.putInt(this._dwLowDateTime, outputStream);
        LittleEndian.putInt(this._dwHighDateTime, outputStream);
        return 8;
    }
}

