/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf.model;

import ai2.org.apache.poi.hpbf.model.HPBFPart;
import ai2.org.apache.poi.hpbf.model.qcbits.QCBit;
import ai2.org.apache.poi.hpbf.model.qcbits.QCPLCBit;
import ai2.org.apache.poi.hpbf.model.qcbits.QCTextBit;
import ai2.org.apache.poi.hpbf.model.qcbits.UnknownQCBit;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import java.io.IOException;

public final class QuillContents
extends HPBFPart {
    private static final String[] PATH = new String[]{"Quill", "QuillSub", "CONTENTS"};
    private QCBit[] bits;

    public QuillContents(DirectoryNode directoryNode) throws IOException {
        super(directoryNode, PATH);
        String string = new String(this.data, 0, 8, LocaleUtil.CHARSET_1252);
        if (!string.equals("CHNKINK ")) {
            throw new IllegalArgumentException("Expecting 'CHNKINK ' but was '" + string + "'");
        }
        this.bits = new QCBit[20];
        for (int i = 0; i < 20; ++i) {
            int n = 32 + i * 24;
            if (this.data[n] != 24 || this.data[n + 1] != 0) continue;
            String string2 = new String(this.data, n + 2, 4, LocaleUtil.CHARSET_1252);
            int n2 = LittleEndian.getUShort(this.data, n + 6);
            int n3 = LittleEndian.getUShort(this.data, n + 8);
            int n4 = LittleEndian.getUShort(this.data, n + 10);
            String string3 = new String(this.data, n + 12, 4, LocaleUtil.CHARSET_1252);
            int n5 = (int)LittleEndian.getUInt(this.data, n + 16);
            int n6 = (int)LittleEndian.getUInt(this.data, n + 20);
            byte[] byArray = new byte[n6];
            System.arraycopy(this.data, n5, byArray, 0, n6);
            this.bits[i] = string3.equals("TEXT") ? new QCTextBit(string2, string3, byArray) : (string3.equals("PLC ") ? QCPLCBit.createQCPLCBit(string2, string3, byArray) : new UnknownQCBit(string2, string3, byArray));
            this.bits[i].setOptA(n2);
            this.bits[i].setOptB(n3);
            this.bits[i].setOptC(n4);
            this.bits[i].setDataOffset(n5);
        }
    }

    public QCBit[] getBits() {
        return this.bits;
    }

    protected void generateData() {
        throw new IllegalStateException("Not done yet!");
    }
}

