/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf.model;

import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class HPBFPart {
    protected byte[] data;

    public HPBFPart(DirectoryNode directoryNode, String[] stringArray) throws IOException {
        DocumentEntry documentEntry;
        DirectoryNode directoryNode2 = this.getDir(stringArray, directoryNode);
        String string = stringArray[stringArray.length - 1];
        try {
            documentEntry = (DocumentEntry)directoryNode2.getEntry(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("File invalid - failed to find document entry '" + string + "'");
        }
        this.data = new byte[documentEntry.getSize()];
        directoryNode2.createDocumentInputStream(string).read(this.data);
    }

    private DirectoryNode getDir(String[] stringArray, DirectoryNode directoryNode) {
        DirectoryNode directoryNode2 = directoryNode;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            try {
                directoryNode2 = (DirectoryNode)directoryNode2.getEntry(stringArray[i]);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException("File invalid - failed to find directory entry '" + stringArray[i] + "'");
            }
        }
        return directoryNode2;
    }

    public void writeOut(DirectoryNode directoryNode) throws IOException {
        String[] stringArray = this.getPath();
        DirectoryNode directoryNode2 = directoryNode;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            try {
                directoryNode2 = (DirectoryNode)directoryNode2.getEntry(stringArray[i]);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                directoryNode2.createDirectory(stringArray[i]);
            }
        }
        this.generateData();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
        directoryNode2.createDocument(stringArray[stringArray.length - 1], byteArrayInputStream);
    }

    protected abstract void generateData();

    public byte[] getData() {
        return this.data;
    }

    public final String[] getPath() {
        return null;
    }
}

