/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.hpbf.HPBFDocument;
import ai2.org.apache.poi.hpbf.model.qcbits.QCBit;
import ai2.org.apache.poi.hpbf.model.qcbits.QCPLCBit;
import ai2.org.apache.poi.hpbf.model.qcbits.QCTextBit;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class PublisherTextExtractor
extends POIOLE2TextExtractor {
    private HPBFDocument doc;
    private boolean hyperlinksByDefault = false;

    public PublisherTextExtractor(HPBFDocument hPBFDocument) {
        super(hPBFDocument);
        this.doc = hPBFDocument;
    }

    public PublisherTextExtractor(DirectoryNode directoryNode) throws IOException {
        this(new HPBFDocument(directoryNode));
    }

    public PublisherTextExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(new HPBFDocument(pOIFSFileSystem));
    }

    public PublisherTextExtractor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(new HPBFDocument(nPOIFSFileSystem));
    }

    public PublisherTextExtractor(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
    }

    public void setHyperlinksByDefault(boolean bl) {
        this.hyperlinksByDefault = bl;
    }

    public String getText() {
        QCBit qCBit;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        QCBit[] qCBitArray = this.doc.getQuillContents().getBits();
        for (n = 0; n < qCBitArray.length; ++n) {
            if (qCBitArray[n] == null || !(qCBitArray[n] instanceof QCTextBit)) continue;
            qCBit = (QCTextBit)qCBitArray[n];
            stringBuffer.append(((QCTextBit)qCBit).getText().replace('\r', '\n'));
        }
        if (this.hyperlinksByDefault) {
            for (n = 0; n < qCBitArray.length; ++n) {
                if (qCBitArray[n] == null || !(qCBitArray[n] instanceof QCPLCBit.Type12)) continue;
                qCBit = (QCPLCBit.Type12)qCBitArray[n];
                for (int i = 0; i < ((QCPLCBit.Type12)qCBit).getNumberOfHyperlinks(); ++i) {
                    stringBuffer.append("<");
                    stringBuffer.append(((QCPLCBit.Type12)qCBit).getHyperlink(i));
                    stringBuffer.append(">\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Use:");
            System.err.println("  PublisherTextExtractor <file.pub>");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            PublisherTextExtractor publisherTextExtractor = new PublisherTextExtractor(new FileInputStream(stringArray[i]));
            System.out.println(publisherTextExtractor.getText());
        }
    }
}

