/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf.dev;

import ai2.org.apache.poi.hpbf.HPBFDocument;
import ai2.org.apache.poi.hpbf.model.QuillContents;
import ai2.org.apache.poi.hpbf.model.qcbits.QCBit;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.HexDump;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class PLCDumper {
    private HPBFDocument doc;
    private QuillContents qc;

    public PLCDumper(HPBFDocument hPBFDocument) {
        this.doc = hPBFDocument;
        this.qc = this.doc.getQuillContents();
    }

    public PLCDumper(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(new HPBFDocument(nPOIFSFileSystem));
    }

    public PLCDumper(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("  PLCDumper <filename>");
            System.exit(1);
        }
        PLCDumper pLCDumper = new PLCDumper(new FileInputStream(stringArray[0]));
        System.out.println("Dumping " + stringArray[0]);
        pLCDumper.dumpPLC();
    }

    private void dumpPLC() {
        QCBit[] qCBitArray = this.qc.getBits();
        for (int i = 0; i < qCBitArray.length; ++i) {
            if (qCBitArray[i] == null || !qCBitArray[i].getBitType().equals("PLC ")) continue;
            this.dumpBit(qCBitArray[i], i);
        }
    }

    private void dumpBit(QCBit qCBit, int n) {
        System.out.println("");
        System.out.println("Dumping " + qCBit.getBitType() + " bit at " + n);
        System.out.println("  Is a " + qCBit.getThingType() + ", number is " + qCBit.getOptA());
        System.out.println("  Starts at " + qCBit.getDataOffset() + " (0x" + Integer.toHexString(qCBit.getDataOffset()) + ")");
        System.out.println("  Runs for  " + qCBit.getLength() + " (0x" + Integer.toHexString(qCBit.getLength()) + ")");
        System.out.println(HexDump.dump(qCBit.getData(), 0L, 0));
    }
}

