/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.dev;

import ai2.org.apache.poi.hmef.attribute.MAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFDateAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFProperty;
import ai2.org.apache.poi.hmef.attribute.TNEFStringAttribute;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class HMEFDumper {
    private InputStream inp;
    private boolean truncatePropertyData;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Filename must be given");
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("--full")) {
                bl = false;
                continue;
            }
            HMEFDumper hMEFDumper = new HMEFDumper(new FileInputStream(stringArray[i]));
            hMEFDumper.setTruncatePropertyData(bl);
            hMEFDumper.dump();
        }
    }

    public HMEFDumper(InputStream inputStream) throws IOException {
        this.inp = inputStream;
        int n = LittleEndian.readInt(inputStream);
        if (n != 574529400) {
            throw new IllegalArgumentException("TNEF signature not detected in file, expected 574529400 but got " + n);
        }
        LittleEndian.readUShort(inputStream);
    }

    public void setTruncatePropertyData(boolean bl) {
        this.truncatePropertyData = bl;
    }

    private void dump() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.inp.read()) != -1) {
            TNEFAttribute tNEFAttribute = TNEFAttribute.create(this.inp);
            if (n == 2 && tNEFAttribute.getProperty() == TNEFProperty.ID_ATTACHRENDERDATA) {
                System.out.println();
                System.out.println("Attachment # " + ++n2);
                System.out.println();
            }
            System.out.println("Level " + n + " : Type " + tNEFAttribute.getType() + " : ID " + tNEFAttribute.getProperty().toString());
            String string = "  ";
            if (tNEFAttribute instanceof TNEFStringAttribute) {
                System.out.println(string + string + string + ((TNEFStringAttribute)tNEFAttribute).getString());
            }
            if (tNEFAttribute instanceof TNEFDateAttribute) {
                System.out.println(string + string + string + ((TNEFDateAttribute)tNEFAttribute).getDate());
            }
            System.out.println(string + "Data of length " + tNEFAttribute.getData().length);
            if (tNEFAttribute.getData().length > 0) {
                int n3;
                int n4 = tNEFAttribute.getData().length;
                if (this.truncatePropertyData) {
                    n4 = Math.min(tNEFAttribute.getData().length, 48);
                }
                if ((n3 = n4 / 16) == 0) {
                    n3 = 1;
                }
                for (int i = 0; i < n3; ++i) {
                    int n5 = 16;
                    int n6 = i * 16;
                    if (i == n3 - 1) {
                        n5 = n4 - n6;
                    }
                    byte[] byArray = new byte[n5];
                    System.arraycopy(tNEFAttribute.getData(), n6, byArray, 0, n5);
                    System.out.print(string + HexDump.dump(byArray, 0L, 0));
                }
            }
            System.out.println();
            if (tNEFAttribute.getProperty() != TNEFProperty.ID_MAPIPROPERTIES && tNEFAttribute.getProperty() != TNEFProperty.ID_ATTACHMENT) continue;
            List<MAPIAttribute> list = MAPIAttribute.create(tNEFAttribute);
            for (MAPIAttribute mAPIAttribute : list) {
                System.out.println(string + string + mAPIAttribute);
            }
            System.out.println();
        }
    }
}

