/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.attribute.TNEFAttribute;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;

public final class TNEFStringAttribute
extends TNEFAttribute {
    private static POILogger logger = POILogFactory.getLogger(TNEFStringAttribute.class);
    private String data;

    protected TNEFStringAttribute(int n, int n2, InputStream inputStream) throws IOException {
        super(n, n2, inputStream);
        String string = null;
        byte[] byArray = this.getData();
        string = this.getType() == 2 ? StringUtil.getFromUnicodeLE(byArray) : StringUtil.getFromCompressedUnicode(byArray, 0, byArray.length);
        if (string.endsWith("\u0000")) {
            string = string.substring(0, string.length() - 1);
        }
        this.data = string;
    }

    public String getString() {
        return this.data;
    }

    public String toString() {
        return "Attribute " + this.getProperty().toString() + ", type=" + this.getType() + ", data=" + this.getString();
    }

    public static String getAsString(TNEFAttribute tNEFAttribute) {
        if (tNEFAttribute == null) {
            return null;
        }
        if (tNEFAttribute instanceof TNEFStringAttribute) {
            return ((TNEFStringAttribute)tNEFAttribute).getString();
        }
        logger.log(5, new Object[]{"Warning, non string property found: " + tNEFAttribute.toString()});
        return null;
    }
}

