/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.attribute.MAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import java.nio.charset.Charset;

public final class MAPIStringAttribute
extends MAPIAttribute {
    private static POILogger logger = POILogFactory.getLogger(MAPIStringAttribute.class);
    private static final String CODEPAGE = "CP1252";
    private final String data;

    public MAPIStringAttribute(MAPIProperty mAPIProperty, int n, byte[] byArray) {
        super(mAPIProperty, n, byArray);
        String string = null;
        if (n == Types.ASCII_STRING.getId()) {
            string = new String(byArray, Charset.forName(CODEPAGE));
        } else if (n == Types.UNICODE_STRING.getId()) {
            string = StringUtil.getFromUnicodeLE(byArray);
        } else {
            throw new IllegalArgumentException("Not a string type " + n);
        }
        if (string.endsWith("\u0000")) {
            string = string.substring(0, string.length() - 1);
        }
        this.data = string;
    }

    public String getDataString() {
        return this.data;
    }

    public String toString() {
        return this.getProperty().toString() + " " + this.data;
    }

    public static String getAsString(MAPIAttribute mAPIAttribute) {
        if (mAPIAttribute == null) {
            return null;
        }
        if (mAPIAttribute instanceof MAPIStringAttribute) {
            return ((MAPIStringAttribute)mAPIAttribute).getDataString();
        }
        if (mAPIAttribute instanceof MAPIRtfAttribute) {
            return ((MAPIRtfAttribute)mAPIAttribute).getDataString();
        }
        logger.log(5, new Object[]{"Warning, non string property found: " + mAPIAttribute.toString()});
        return null;
    }
}

