/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef;

import ai2.org.apache.poi.hmef.attribute.MAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.MAPIStringAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFDateAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFMAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFProperty;
import ai2.org.apache.poi.hmef.attribute.TNEFStringAttribute;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Attachment {
    private final List<TNEFAttribute> attributes = new ArrayList<TNEFAttribute>();
    private final List<MAPIAttribute> mapiAttributes = new ArrayList<MAPIAttribute>();

    protected void addAttribute(TNEFAttribute tNEFAttribute) {
        this.attributes.add(tNEFAttribute);
        if (tNEFAttribute instanceof TNEFMAPIAttribute) {
            TNEFMAPIAttribute tNEFMAPIAttribute = (TNEFMAPIAttribute)tNEFAttribute;
            this.mapiAttributes.addAll(tNEFMAPIAttribute.getMAPIAttributes());
        }
    }

    public TNEFAttribute getAttribute(TNEFProperty tNEFProperty) {
        for (TNEFAttribute tNEFAttribute : this.attributes) {
            if (tNEFAttribute.getProperty() != tNEFProperty) continue;
            return tNEFAttribute;
        }
        return null;
    }

    public MAPIAttribute getMAPIAttribute(MAPIProperty mAPIProperty) {
        for (MAPIAttribute mAPIAttribute : this.mapiAttributes) {
            if (mAPIAttribute.getProperty() != mAPIProperty) continue;
            return mAPIAttribute;
        }
        return null;
    }

    public List<TNEFAttribute> getAttributes() {
        return this.attributes;
    }

    public List<MAPIAttribute> getMAPIAttributes() {
        return this.mapiAttributes;
    }

    private String getString(MAPIProperty mAPIProperty) {
        return MAPIStringAttribute.getAsString(this.getMAPIAttribute(mAPIProperty));
    }

    private String getString(TNEFProperty tNEFProperty) {
        return TNEFStringAttribute.getAsString(this.getAttribute(tNEFProperty));
    }

    public String getFilename() {
        return this.getString(TNEFProperty.ID_ATTACHTITLE);
    }

    public String getLongFilename() {
        return this.getString(MAPIProperty.ATTACH_LONG_FILENAME);
    }

    public String getExtension() {
        return this.getString(MAPIProperty.ATTACH_EXTENSION);
    }

    public Date getModifiedDate() {
        return TNEFDateAttribute.getAsDate(this.getAttribute(TNEFProperty.ID_ATTACHMODIFYDATE));
    }

    public byte[] getContents() {
        TNEFAttribute tNEFAttribute = this.getAttribute(TNEFProperty.ID_ATTACHDATA);
        if (tNEFAttribute == null) {
            throw new IllegalArgumentException("Attachment corrupt - no Data section");
        }
        return tNEFAttribute.getData();
    }

    public byte[] getRenderedMetaFile() {
        TNEFAttribute tNEFAttribute = this.getAttribute(TNEFProperty.ID_ATTACHMETAFILE);
        if (tNEFAttribute == null) {
            return null;
        }
        return tNEFAttribute.getData();
    }
}

