/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.streams;

import ai2.org.apache.poi.hdgf.chunks.ChunkFactory;
import ai2.org.apache.poi.hdgf.exceptions.HDGFException;
import ai2.org.apache.poi.hdgf.pointers.Pointer;
import ai2.org.apache.poi.hdgf.pointers.PointerFactory;
import ai2.org.apache.poi.hdgf.streams.ChunkStream;
import ai2.org.apache.poi.hdgf.streams.CompressedStreamStore;
import ai2.org.apache.poi.hdgf.streams.PointerContainingStream;
import ai2.org.apache.poi.hdgf.streams.StreamStore;
import ai2.org.apache.poi.hdgf.streams.StringsStream;
import ai2.org.apache.poi.hdgf.streams.TrailerStream;
import ai2.org.apache.poi.hdgf.streams.UnknownStream;
import java.io.IOException;

public abstract class Stream {
    private Pointer pointer;
    private StreamStore store;

    public Pointer getPointer() {
        return this.pointer;
    }

    protected StreamStore getStore() {
        return this.store;
    }

    public StreamStore _getStore() {
        return this.store;
    }

    public int _getContentsLength() {
        return this.store.getContents().length;
    }

    protected Stream(Pointer pointer, StreamStore streamStore) {
        this.pointer = pointer;
        this.store = streamStore;
    }

    public static Stream createStream(Pointer pointer, byte[] byArray, ChunkFactory chunkFactory, PointerFactory pointerFactory) {
        StreamStore streamStore;
        if (pointer.destinationCompressed()) {
            try {
                streamStore = new CompressedStreamStore(byArray, pointer.getOffset(), pointer.getLength());
            }
            catch (IOException iOException) {
                throw new HDGFException(iOException);
            }
        } else {
            streamStore = new StreamStore(byArray, pointer.getOffset(), pointer.getLength());
        }
        if (pointer.getType() == 20) {
            return new TrailerStream(pointer, streamStore, chunkFactory, pointerFactory);
        }
        if (pointer.destinationHasPointers()) {
            return new PointerContainingStream(pointer, streamStore, chunkFactory, pointerFactory);
        }
        if (pointer.destinationHasChunks()) {
            return new ChunkStream(pointer, streamStore, chunkFactory);
        }
        if (pointer.destinationHasStrings()) {
            return new StringsStream(pointer, streamStore, chunkFactory);
        }
        return new UnknownStream(pointer, streamStore);
    }
}

