/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.streams;

import ai2.org.apache.poi.hdgf.chunks.ChunkFactory;
import ai2.org.apache.poi.hdgf.pointers.Pointer;
import ai2.org.apache.poi.hdgf.pointers.PointerFactory;
import ai2.org.apache.poi.hdgf.streams.ChunkStream;
import ai2.org.apache.poi.hdgf.streams.Stream;
import ai2.org.apache.poi.hdgf.streams.StreamStore;
import ai2.org.apache.poi.util.LittleEndian;

public class PointerContainingStream
extends Stream {
    private Pointer[] childPointers;
    private Stream[] childStreams;
    private ChunkFactory chunkFactory;
    private PointerFactory pointerFactory;
    private int numPointersLocalOffset;

    protected PointerContainingStream(Pointer pointer, StreamStore streamStore, ChunkFactory chunkFactory, PointerFactory pointerFactory) {
        super(pointer, streamStore);
        this.chunkFactory = chunkFactory;
        this.pointerFactory = pointerFactory;
        this.numPointersLocalOffset = (int)LittleEndian.getUInt(streamStore.getContents(), 0);
        int n = (int)LittleEndian.getUInt(streamStore.getContents(), this.numPointersLocalOffset);
        this.childPointers = new Pointer[n];
        int n2 = this.numPointersLocalOffset + 4 + 4;
        for (int i = 0; i < n; ++i) {
            this.childPointers[i] = pointerFactory.createPointer(streamStore.getContents(), n2);
            n2 += this.childPointers[i].getSizeInBytes();
        }
    }

    protected Pointer[] getChildPointers() {
        return this.childPointers;
    }

    public Stream[] getPointedToStreams() {
        return this.childStreams;
    }

    public void findChildren(byte[] byArray) {
        this.childStreams = new Stream[this.childPointers.length];
        for (int i = 0; i < this.childPointers.length; ++i) {
            Stream stream;
            Pointer pointer = this.childPointers[i];
            this.childStreams[i] = Stream.createStream(pointer, byArray, this.chunkFactory, this.pointerFactory);
            if (this.childStreams[i] instanceof ChunkStream) {
                stream = (ChunkStream)this.childStreams[i];
                ((ChunkStream)stream).findChunks();
            }
            if (!(this.childStreams[i] instanceof PointerContainingStream)) continue;
            stream = (PointerContainingStream)this.childStreams[i];
            ((PointerContainingStream)stream).findChildren(byArray);
        }
    }
}

