/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.chunks;

import ai2.org.apache.poi.hdgf.chunks.ChunkFactory;
import ai2.org.apache.poi.hdgf.chunks.ChunkHeader;
import ai2.org.apache.poi.hdgf.chunks.ChunkSeparator;
import ai2.org.apache.poi.hdgf.chunks.ChunkTrailer;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;

public final class Chunk {
    private byte[] contents;
    private ChunkHeader header;
    private ChunkTrailer trailer;
    private ChunkSeparator separator;
    protected ChunkFactory.CommandDefinition[] commandDefinitions;
    private Command[] commands;
    private String name;
    private POILogger logger = POILogFactory.getLogger(Chunk.class);

    public Chunk(ChunkHeader chunkHeader, ChunkTrailer chunkTrailer, ChunkSeparator chunkSeparator, byte[] byArray) {
        this.header = chunkHeader;
        this.trailer = chunkTrailer;
        this.separator = chunkSeparator;
        this.contents = byArray;
    }

    public byte[] _getContents() {
        return this.contents;
    }

    public ChunkHeader getHeader() {
        return this.header;
    }

    public ChunkSeparator getSeparator() {
        return this.separator;
    }

    public ChunkTrailer getTrailer() {
        return this.trailer;
    }

    public ChunkFactory.CommandDefinition[] getCommandDefinitions() {
        return this.commandDefinitions;
    }

    public Command[] getCommands() {
        return this.commands;
    }

    public String getName() {
        return this.name;
    }

    public int getOnDiskSize() {
        int n = this.header.getSizeInBytes() + this.contents.length;
        if (this.trailer != null) {
            n += this.trailer.trailerData.length;
        }
        if (this.separator != null) {
            n += this.separator.separatorData.length;
        }
        return n;
    }

    protected void processCommands() {
        if (this.commandDefinitions == null) {
            throw new IllegalStateException("You must supply the command definitions before calling processCommands!");
        }
        ArrayList<BlockOffsetCommand> arrayList = new ArrayList<BlockOffsetCommand>();
        for (int i = 0; i < this.commandDefinitions.length; ++i) {
            int n = this.commandDefinitions[i].getType();
            int n2 = this.commandDefinitions[i].getOffset();
            if (n == 10) {
                this.name = this.commandDefinitions[i].getName();
                continue;
            }
            if (n == 18) continue;
            Command command = n == 11 || n == 21 ? new BlockOffsetCommand(this.commandDefinitions[i]) : new Command(this.commandDefinitions[i]);
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 28: 
                case 29: {
                    break;
                }
                default: {
                    if (n2 < 19) break;
                    n2 -= 19;
                }
            }
            if (n2 >= this.contents.length) {
                this.logger.log(5, new Object[]{"Command offset " + n2 + " past end of data at " + this.contents.length});
                continue;
            }
            try {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        int n3 = this.contents[n2] & 1 << n;
                        command.value = n3 > 0;
                        break;
                    }
                    case 8: {
                        command.value = this.contents[n2];
                        break;
                    }
                    case 9: {
                        command.value = new Double(LittleEndian.getDouble(this.contents, n2));
                        break;
                    }
                    case 12: {
                        int n4;
                        int n5;
                        if (this.contents.length < 8) {
                            command.value = "";
                            break;
                        }
                        int n6 = n5 = 8;
                        for (n4 = n5; n4 < this.contents.length - 1 && n6 == n5; ++n4) {
                            if (this.contents[n4] != 0 || this.contents[n4 + 1] != 0) continue;
                            n6 = n4;
                        }
                        if (n6 == n5) {
                            n6 = this.contents.length;
                        }
                        n4 = n6 - n5;
                        command.value = new String(this.contents, n5, n4, this.header.getChunkCharset().name());
                        break;
                    }
                    case 25: {
                        command.value = LittleEndian.getShort(this.contents, n2);
                        break;
                    }
                    case 26: {
                        command.value = LittleEndian.getInt(this.contents, n2);
                        break;
                    }
                    case 11: 
                    case 21: {
                        if (n2 < this.contents.length - 3) {
                            int n7 = (int)LittleEndian.getUInt(this.contents, n2);
                            Command command2 = command;
                            ((BlockOffsetCommand)command2).setOffset(n7);
                        }
                        break;
                    }
                    default: {
                        this.logger.log(3, new Object[]{"Command of type " + n + " not processed!"});
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this.logger.log(7, new Object[]{"Unexpected error processing command, ignoring and continuing. Command: " + command, exception});
            }
            arrayList.add((BlockOffsetCommand)command);
        }
        this.commands = arrayList.toArray(new Command[arrayList.size()]);
    }

    public static class BlockOffsetCommand
    extends Command {
        private int offset;

        private BlockOffsetCommand(ChunkFactory.CommandDefinition commandDefinition) {
            super(commandDefinition, null);
        }

        private void setOffset(int n) {
            this.offset = n;
            this.value = n;
        }
    }

    public static class Command {
        protected Object value;
        private ChunkFactory.CommandDefinition definition;

        private Command(ChunkFactory.CommandDefinition commandDefinition, Object object) {
            this.definition = commandDefinition;
            this.value = object;
        }

        private Command(ChunkFactory.CommandDefinition commandDefinition) {
            this(commandDefinition, (Object)null);
        }

        public ChunkFactory.CommandDefinition getDefinition() {
            return this.definition;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

