/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdf.model.hdftypes;

import ai2.org.apache.poi.hdf.model.hdftypes.CharacterProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.HDFType;
import ai2.org.apache.poi.hdf.model.hdftypes.ParagraphProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.SectionProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.StyleDescription;
import ai2.org.apache.poi.hdf.model.hdftypes.TableCellDescriptor;
import ai2.org.apache.poi.hdf.model.hdftypes.TableProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.definitions.TCAbstractType;
import ai2.org.apache.poi.util.LittleEndian;

@Deprecated
public final class StyleSheet
implements HDFType {
    private static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    StyleDescription _nilStyle = new StyleDescription();
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] byArray) {
        int n;
        short s = LittleEndian.getShort(byArray, 0);
        int n2 = LittleEndian.getShort(byArray, 2);
        short s2 = LittleEndian.getShort(byArray, 4);
        int[] nArray = new int[]{LittleEndian.getInt(byArray, 14), LittleEndian.getInt(byArray, 18), LittleEndian.getInt(byArray, 22)};
        int n3 = 0;
        this._styleDescriptions = new StyleDescription[n2];
        for (n = 0; n < n2; ++n) {
            int n4 = 2 + s + n3;
            short s3 = LittleEndian.getShort(byArray, n4);
            if (s3 > 0) {
                StyleDescription styleDescription;
                byte[] byArray2 = new byte[s3];
                System.arraycopy(byArray, n4 += 2, byArray2, 0, s3);
                this._styleDescriptions[n] = styleDescription = new StyleDescription(byArray2, s2, true);
            }
            n3 += s3 + 2;
        }
        for (n = 0; n < this._styleDescriptions.length; ++n) {
            if (this._styleDescriptions[n] == null) continue;
            this.createPap(n);
            this.createChp(n);
        }
    }

    private void createPap(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        ParagraphProperties paragraphProperties = styleDescription.getPAP();
        byte[] byArray = styleDescription.getPAPX();
        int n2 = styleDescription.getBaseStyle();
        if (paragraphProperties == null && byArray != null) {
            ParagraphProperties paragraphProperties2 = this._nilStyle.getPAP();
            if (n2 != 4095 && (paragraphProperties2 = this._styleDescriptions[n2].getPAP()) == null) {
                this.createPap(n2);
                paragraphProperties2 = this._styleDescriptions[n2].getPAP();
            }
            paragraphProperties = (ParagraphProperties)StyleSheet.uncompressProperty(byArray, paragraphProperties2, this);
            styleDescription.setPAP(paragraphProperties);
        }
    }

    private void createChp(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        CharacterProperties characterProperties = styleDescription.getCHP();
        byte[] byArray = styleDescription.getCHPX();
        int n2 = styleDescription.getBaseStyle();
        if (characterProperties == null && byArray != null) {
            CharacterProperties characterProperties2 = this._nilStyle.getCHP();
            if (n2 != 4095 && (characterProperties2 = this._styleDescriptions[n2].getCHP()) == null) {
                this.createChp(n2);
                characterProperties2 = this._styleDescriptions[n2].getCHP();
            }
            characterProperties = (CharacterProperties)StyleSheet.uncompressProperty(byArray, characterProperties2, this);
            styleDescription.setCHP(characterProperties);
        }
    }

    public StyleDescription getStyleDescription(int n) {
        return this._styleDescriptions[n];
    }

    static void doCHPOperation(CharacterProperties characterProperties, CharacterProperties characterProperties2, int n, int n2, byte[] byArray, byte[] byArray2, int n3, StyleSheet styleSheet) {
        switch (n) {
            case 0: {
                characterProperties2.setFRMarkDel(StyleSheet.getFlag(n2));
                break;
            }
            case 1: {
                characterProperties2.setFRMark(StyleSheet.getFlag(n2));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                characterProperties2.setFcPic(n2);
                characterProperties2.setFSpec(true);
                break;
            }
            case 4: {
                characterProperties2.setIbstRMark((short)n2);
                break;
            }
            case 5: {
                short[] sArray = new short[]{LittleEndian.getShort(byArray2, n3 - 4), LittleEndian.getShort(byArray2, n3 - 2)};
                characterProperties2.setDttmRMark(sArray);
                break;
            }
            case 6: {
                characterProperties2.setFData(StyleSheet.getFlag(n2));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                short s = (short)((n2 & 0xFF0000) >>> 8);
                characterProperties2.setFChsDiff(StyleSheet.getFlag(s));
                characterProperties2.setChse((short)(n2 & 0xFFFF));
                break;
            }
            case 9: {
                characterProperties2.setFSpec(true);
                characterProperties2.setFtcSym(LittleEndian.getShort(byArray, 0));
                characterProperties2.setXchSym(LittleEndian.getShort(byArray, 2));
                break;
            }
            case 10: {
                characterProperties2.setFOle2(StyleSheet.getFlag(n2));
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                characterProperties2.setIcoHighlight((byte)n2);
                characterProperties2.setFHighlight(StyleSheet.getFlag(n2));
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                characterProperties2.setFcObj(n2);
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                characterProperties2.setIstd(n2);
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                characterProperties2.setFBold(false);
                characterProperties2.setFItalic(false);
                characterProperties2.setFOutline(false);
                characterProperties2.setFStrike(false);
                characterProperties2.setFShadow(false);
                characterProperties2.setFSmallCaps(false);
                characterProperties2.setFCaps(false);
                characterProperties2.setFVanish(false);
                characterProperties2.setKul((byte)0);
                characterProperties2.setIco((byte)0);
                break;
            }
            case 51: {
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                characterProperties2.setFBold(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFBold()));
                break;
            }
            case 54: {
                characterProperties2.setFItalic(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFItalic()));
                break;
            }
            case 55: {
                characterProperties2.setFStrike(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFStrike()));
                break;
            }
            case 56: {
                characterProperties2.setFOutline(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFOutline()));
                break;
            }
            case 57: {
                characterProperties2.setFShadow(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFShadow()));
                break;
            }
            case 58: {
                characterProperties2.setFSmallCaps(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFSmallCaps()));
                break;
            }
            case 59: {
                characterProperties2.setFCaps(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFCaps()));
                break;
            }
            case 60: {
                characterProperties2.setFVanish(StyleSheet.getCHPFlag((byte)n2, characterProperties.isFVanish()));
                break;
            }
            case 61: {
                characterProperties2.setFtcAscii((short)n2);
                break;
            }
            case 62: {
                characterProperties2.setKul((byte)n2);
                break;
            }
            case 63: {
                boolean bl;
                byte by;
                byte by2;
                int n4 = n2 & 0xFF;
                if (n4 != 0) {
                    characterProperties2.setHps(n4);
                }
                if ((by2 = (byte)((byte)(n2 & 0xFE00) >>> 4 >> 1)) != 0) {
                    characterProperties2.setHps(Math.max(characterProperties2.getHps() + by2 * 2, 2));
                }
                if ((by = (byte)((n2 & 0xFF0000) >>> 8)) != 128) {
                    characterProperties2.setHpsPos(by);
                }
                boolean bl2 = bl = (n2 & 0x100) > 0;
                if (bl && by != 128 && by != 0 && characterProperties.getHpsPos() == 0) {
                    characterProperties2.setHps(Math.max(characterProperties2.getHps() + -2, 2));
                }
                if (!bl || by != 0 || characterProperties.getHpsPos() == 0) break;
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + 2, 2));
                break;
            }
            case 64: {
                characterProperties2.setDxaSpace(n2);
                break;
            }
            case 65: {
                characterProperties2.setLidDefault((short)n2);
                break;
            }
            case 66: {
                characterProperties2.setIco((byte)n2);
                break;
            }
            case 67: {
                characterProperties2.setHps(n2);
                break;
            }
            case 68: {
                byte by = (byte)n2;
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + by * 2, 2));
                break;
            }
            case 69: {
                characterProperties2.setHpsPos((short)n2);
                break;
            }
            case 70: {
                if (n2 != 0) {
                    if (characterProperties.getHpsPos() != 0) break;
                    characterProperties2.setHps(Math.max(characterProperties2.getHps() + -2, 2));
                    break;
                }
                if (characterProperties.getHpsPos() == 0) break;
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + 2, 2));
                break;
            }
            case 71: {
                CharacterProperties characterProperties3 = new CharacterProperties();
                characterProperties3.setFtcAscii(4);
                characterProperties3 = (CharacterProperties)StyleSheet.uncompressProperty(byArray, characterProperties3, styleSheet);
                CharacterProperties characterProperties4 = styleSheet.getStyleDescription(characterProperties.getBaseIstd()).getCHP();
                if (characterProperties3.isFBold() == characterProperties2.isFBold()) {
                    characterProperties2.setFBold(characterProperties4.isFBold());
                }
                if (characterProperties3.isFItalic() == characterProperties2.isFItalic()) {
                    characterProperties2.setFItalic(characterProperties4.isFItalic());
                }
                if (characterProperties3.isFSmallCaps() == characterProperties2.isFSmallCaps()) {
                    characterProperties2.setFSmallCaps(characterProperties4.isFSmallCaps());
                }
                if (characterProperties3.isFVanish() == characterProperties2.isFVanish()) {
                    characterProperties2.setFVanish(characterProperties4.isFVanish());
                }
                if (characterProperties3.isFStrike() == characterProperties2.isFStrike()) {
                    characterProperties2.setFStrike(characterProperties4.isFStrike());
                }
                if (characterProperties3.isFCaps() == characterProperties2.isFCaps()) {
                    characterProperties2.setFCaps(characterProperties4.isFCaps());
                }
                if (characterProperties3.getFtcAscii() == characterProperties2.getFtcAscii()) {
                    characterProperties2.setFtcAscii(characterProperties4.getFtcAscii());
                }
                if (characterProperties3.getFtcFE() == characterProperties2.getFtcFE()) {
                    characterProperties2.setFtcFE(characterProperties4.getFtcFE());
                }
                if (characterProperties3.getFtcOther() == characterProperties2.getFtcOther()) {
                    characterProperties2.setFtcOther(characterProperties4.getFtcOther());
                }
                if (characterProperties3.getHps() == characterProperties2.getHps()) {
                    characterProperties2.setHps(characterProperties4.getHps());
                }
                if (characterProperties3.getHpsPos() == characterProperties2.getHpsPos()) {
                    characterProperties2.setHpsPos(characterProperties4.getHpsPos());
                }
                if (characterProperties3.getKul() == characterProperties2.getKul()) {
                    characterProperties2.setKul(characterProperties4.getKul());
                }
                if (characterProperties3.getDxaSpace() == characterProperties2.getDxaSpace()) {
                    characterProperties2.setDxaSpace(characterProperties4.getDxaSpace());
                }
                if (characterProperties3.getIco() == characterProperties2.getIco()) {
                    characterProperties2.setIco(characterProperties4.getIco());
                }
                if (characterProperties3.getLidDefault() == characterProperties2.getLidDefault()) {
                    characterProperties2.setLidDefault(characterProperties4.getLidDefault());
                }
                if (characterProperties3.getLidFE() != characterProperties2.getLidFE()) break;
                characterProperties2.setLidFE(characterProperties4.getLidFE());
                break;
            }
            case 72: {
                characterProperties2.setIss((byte)n2);
                break;
            }
            case 73: {
                characterProperties2.setHps(LittleEndian.getShort(byArray, 0));
                break;
            }
            case 74: {
                short s = LittleEndian.getShort(byArray, 0);
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + s, 8));
                break;
            }
            case 75: {
                characterProperties2.setHpsKern(n2);
                break;
            }
            case 76: {
                StyleSheet.doCHPOperation(characterProperties, characterProperties2, 71, n2, byArray, byArray2, n3, styleSheet);
                break;
            }
            case 77: {
                float f = (float)n2 / 100.0f;
                int n5 = (int)(f * (float)characterProperties2.getHps());
                characterProperties2.setHps(characterProperties2.getHps() + n5);
                break;
            }
            case 78: {
                characterProperties2.setYsr((byte)n2);
                break;
            }
            case 79: {
                characterProperties2.setFtcAscii((short)n2);
                break;
            }
            case 80: {
                characterProperties2.setFtcFE((short)n2);
                break;
            }
            case 81: {
                characterProperties2.setFtcOther((short)n2);
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                characterProperties2.setFDStrike(StyleSheet.getFlag(n2));
                break;
            }
            case 84: {
                characterProperties2.setFImprint(StyleSheet.getFlag(n2));
                break;
            }
            case 85: {
                characterProperties2.setFSpec(StyleSheet.getFlag(n2));
                break;
            }
            case 86: {
                characterProperties2.setFObj(StyleSheet.getFlag(n2));
                break;
            }
            case 87: {
                characterProperties2.setFPropMark(byArray[0]);
                characterProperties2.setIbstPropRMark(LittleEndian.getShort(byArray, 1));
                characterProperties2.setDttmPropRMark(LittleEndian.getInt(byArray, 3));
                break;
            }
            case 88: {
                characterProperties2.setFEmboss(StyleSheet.getFlag(n2));
                break;
            }
            case 89: {
                characterProperties2.setSfxtText((byte)n2);
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                break;
            }
            case 97: {
                break;
            }
            case 98: {
                byte[] byArray3 = new byte[32];
                characterProperties2.setFDispFldRMark(byArray[0]);
                characterProperties2.setIbstDispFldRMark(LittleEndian.getShort(byArray, 1));
                characterProperties2.setDttmDispFldRMark(LittleEndian.getInt(byArray, 3));
                System.arraycopy(byArray, 7, byArray3, 0, 32);
                characterProperties2.setXstDispFldRMark(byArray3);
                break;
            }
            case 99: {
                characterProperties2.setIbstRMarkDel((short)n2);
                break;
            }
            case 100: {
                short[] sArray = new short[]{LittleEndian.getShort(byArray2, n3 - 4), LittleEndian.getShort(byArray2, n3 - 2)};
                characterProperties2.setDttmRMarkDel(sArray);
                break;
            }
            case 101: {
                short[] sArray = new short[]{LittleEndian.getShort(byArray2, n3 - 4), LittleEndian.getShort(byArray2, n3 - 2)};
                characterProperties2.setBrc(sArray);
                break;
            }
            case 102: {
                characterProperties2.setShd((short)n2);
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                characterProperties2.setLidDefault((short)n2);
                break;
            }
            case 110: {
                characterProperties2.setLidFE((short)n2);
                break;
            }
            case 111: {
                characterProperties2.setIdctHint((byte)n2);
            }
        }
    }

    public static Object uncompressProperty(byte[] byArray, Object object, StyleSheet styleSheet) {
        return StyleSheet.uncompressProperty(byArray, object, styleSheet, true);
    }

    public static Object uncompressProperty(byte[] byArray, Object object, StyleSheet styleSheet, boolean bl) {
        Object object2 = null;
        int n = 0;
        int n2 = 1;
        if (object instanceof ParagraphProperties) {
            try {
                object2 = ((ParagraphProperties)object).clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                ((ParagraphProperties)object2).setIstd(LittleEndian.getShort(byArray, 0));
                n = 2;
            }
        } else if (object instanceof CharacterProperties) {
            try {
                object2 = ((CharacterProperties)object).clone();
                ((CharacterProperties)object2).setBaseIstd(((CharacterProperties)object).getIstd());
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = 2;
        } else if (object instanceof SectionProperties) {
            object2 = object;
            n2 = 4;
        } else if (object instanceof TableProperties) {
            object2 = object;
            n2 = 5;
            n = 2;
        } else {
            return null;
        }
        while (n < byArray.length) {
            short s = LittleEndian.getShort(byArray, n);
            n += 2;
            byte by = (byte)((s & 0xE000) >> 13);
            int n3 = 0;
            int n4 = 0;
            byte[] byArray2 = null;
            switch (by) {
                case 0: 
                case 1: {
                    n3 = 1;
                    n4 = byArray[n];
                    break;
                }
                case 2: {
                    n3 = 2;
                    n4 = LittleEndian.getShort(byArray, n);
                    break;
                }
                case 3: {
                    n3 = 4;
                    n4 = LittleEndian.getInt(byArray, n);
                    break;
                }
                case 4: 
                case 5: {
                    n3 = 2;
                    n4 = LittleEndian.getShort(byArray, n);
                    break;
                }
                case 6: {
                    if (s != -10744) {
                        n3 = LittleEndian.getUnsignedByte(byArray, n);
                        ++n;
                    } else {
                        n3 = LittleEndian.getShort(byArray, n) - 1;
                        n += 2;
                    }
                    byArray2 = new byte[n3];
                    System.arraycopy(byArray, n, byArray2, 0, n3);
                    break;
                }
                case 7: {
                    n3 = 3;
                    byte[] byArray3 = new byte[]{byArray[n], byArray[n + 1], byArray[n + 2], 0};
                    n4 = LittleEndian.getInt(byArray3, 0);
                    break;
                }
                default: {
                    throw new RuntimeException("unrecognized pap opcode");
                }
            }
            n += n3;
            short s2 = (short)(s & 0x1FF);
            byte by2 = (byte)((s & 0x1C00) >> 10);
            switch (n2) {
                case 1: {
                    if (by2 != 1) break;
                    StyleSheet.doPAPOperation((ParagraphProperties)object2, s2, n4, byArray2, byArray, n, by);
                    break;
                }
                case 2: {
                    StyleSheet.doCHPOperation((CharacterProperties)object, (CharacterProperties)object2, s2, n4, byArray2, byArray, n, styleSheet);
                    break;
                }
                case 4: {
                    StyleSheet.doSEPOperation((SectionProperties)object2, s2, n4, byArray2);
                    break;
                }
                case 5: {
                    if (by2 != 5) break;
                    StyleSheet.doTAPOperation((TableProperties)object2, s2, n4, byArray2);
                }
            }
        }
        return object2;
    }

    static void doPAPOperation(ParagraphProperties paragraphProperties, int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        switch (n) {
            case 0: {
                paragraphProperties.setIstd(n2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (paragraphProperties.getIstd() > 9 && paragraphProperties.getIstd() < 1) break;
                paragraphProperties.setIstd(paragraphProperties.getIstd() + n2);
                if (n2 > 0) {
                    paragraphProperties.setIstd(Math.max(paragraphProperties.getIstd(), 9));
                    break;
                }
                paragraphProperties.setIstd(Math.min(paragraphProperties.getIstd(), 1));
                break;
            }
            case 3: {
                paragraphProperties.setJc((byte)n2);
                break;
            }
            case 4: {
                paragraphProperties.setFSideBySide((byte)n2);
                break;
            }
            case 5: {
                paragraphProperties.setFKeep((byte)n2);
                break;
            }
            case 6: {
                paragraphProperties.setFKeepFollow((byte)n2);
                break;
            }
            case 7: {
                paragraphProperties.setFPageBreakBefore((byte)n2);
                break;
            }
            case 8: {
                paragraphProperties.setBrcl((byte)n2);
                break;
            }
            case 9: {
                paragraphProperties.setBrcp((byte)n2);
                break;
            }
            case 10: {
                paragraphProperties.setIlvl((byte)n2);
                break;
            }
            case 11: {
                paragraphProperties.setIlfo(n2);
                break;
            }
            case 12: {
                paragraphProperties.setFNoLnn((byte)n2);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                paragraphProperties.setDxaRight(n2);
                break;
            }
            case 15: {
                paragraphProperties.setDxaLeft(n2);
                break;
            }
            case 16: {
                paragraphProperties.setDxaLeft(paragraphProperties.getDxaLeft() + n2);
                paragraphProperties.setDxaLeft(Math.max(0, paragraphProperties.getDxaLeft()));
                break;
            }
            case 17: {
                paragraphProperties.setDxaLeft1(n2);
                break;
            }
            case 18: {
                short[] sArray = paragraphProperties.getLspd();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 19: {
                paragraphProperties.setDyaBefore(n2);
                break;
            }
            case 20: {
                paragraphProperties.setDyaAfter(n2);
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                paragraphProperties.setFInTable((byte)n2);
                break;
            }
            case 23: {
                paragraphProperties.setFTtp((byte)n2);
                break;
            }
            case 24: {
                paragraphProperties.setDxaAbs(n2);
                break;
            }
            case 25: {
                paragraphProperties.setDyaAbs(n2);
                break;
            }
            case 26: {
                paragraphProperties.setDxaWidth(n2);
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                paragraphProperties.setDxaFromText(n2);
                break;
            }
            case 35: {
                paragraphProperties.setWr((byte)n2);
                break;
            }
            case 36: {
                short[] sArray = paragraphProperties.getBrcTop();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 37: {
                short[] sArray = paragraphProperties.getBrcLeft();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 38: {
                short[] sArray = paragraphProperties.getBrcBottom();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 39: {
                short[] sArray = paragraphProperties.getBrcRight();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 40: {
                short[] sArray = paragraphProperties.getBrcBetween();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 41: {
                short[] sArray = paragraphProperties.getBrcBar();
                sArray[0] = LittleEndian.getShort(byArray2, n3 - 4);
                sArray[1] = LittleEndian.getShort(byArray2, n3 - 2);
                break;
            }
            case 42: {
                paragraphProperties.setFNoAutoHyph((byte)n2);
                break;
            }
            case 43: {
                paragraphProperties.setDyaHeight(n2);
                break;
            }
            case 44: {
                paragraphProperties.setDcs((short)n2);
                break;
            }
            case 45: {
                paragraphProperties.setShd((short)n2);
                break;
            }
            case 46: {
                paragraphProperties.setDyaFromText(n2);
                break;
            }
            case 47: {
                paragraphProperties.setDxaFromText(n2);
                break;
            }
            case 48: {
                paragraphProperties.setFLocked((byte)n2);
                break;
            }
            case 49: {
                paragraphProperties.setFWidowControl((byte)n2);
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                paragraphProperties.setFKinsoku((byte)n2);
                break;
            }
            case 52: {
                paragraphProperties.setFWordWrap((byte)n2);
                break;
            }
            case 53: {
                paragraphProperties.setFOverflowPunct((byte)n2);
                break;
            }
            case 54: {
                paragraphProperties.setFTopLinePunct((byte)n2);
                break;
            }
            case 55: {
                paragraphProperties.setFAutoSpaceDE((byte)n2);
                break;
            }
            case 56: {
                paragraphProperties.setFAutoSpaceDN((byte)n2);
                break;
            }
            case 57: {
                paragraphProperties.setWAlignFont(n2);
                break;
            }
            case 58: {
                paragraphProperties.setFontAlign((short)n2);
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                paragraphProperties.setAnld(byArray);
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                break;
            }
            case 67: {
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (n4 != 6) break;
                paragraphProperties.setNumrm(byArray);
                break;
            }
            case 71: {
                paragraphProperties.setFUsePgsuSettings((byte)n2);
                break;
            }
            case 72: {
                paragraphProperties.setFAdjustRight((byte)n2);
                break;
            }
        }
    }

    static void doTAPOperation(TableProperties tableProperties, int n, int n2, byte[] byArray) {
        switch (n) {
            case 0: {
                tableProperties.setJc((short)n2);
                break;
            }
            case 1: {
                short[] sArray = tableProperties.getRgdxaCenter();
                int n3 = tableProperties.getItcMac();
                int n4 = n2 - (sArray[0] + tableProperties.getDxaGapHalf());
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = n5++;
                    sArray[n6] = (short)(sArray[n6] + n4);
                }
                break;
            }
            case 2: {
                short[] sArray = tableProperties.getRgdxaCenter();
                if (sArray != null) {
                    int n7 = tableProperties.getDxaGapHalf() - n2;
                    sArray[0] = (short)(sArray[0] + n7);
                }
                tableProperties.setDxaGapHalf(n2);
                break;
            }
            case 3: {
                tableProperties.setFCantSplit(StyleSheet.getFlag(n2));
                break;
            }
            case 4: {
                tableProperties.setFTableHeader(StyleSheet.getFlag(n2));
                break;
            }
            case 5: {
                short[] sArray = tableProperties.getBrcTop();
                short[] sArray2 = tableProperties.getBrcLeft();
                short[] sArray3 = tableProperties.getBrcBottom();
                short[] sArray4 = tableProperties.getBrcRight();
                short[] sArray5 = tableProperties.getBrcVertical();
                short[] sArray6 = tableProperties.getBrcHorizontal();
                sArray[0] = LittleEndian.getShort(byArray, 0);
                sArray[1] = LittleEndian.getShort(byArray, 2);
                sArray2[0] = LittleEndian.getShort(byArray, 4);
                sArray2[1] = LittleEndian.getShort(byArray, 6);
                sArray3[0] = LittleEndian.getShort(byArray, 8);
                sArray3[1] = LittleEndian.getShort(byArray, 10);
                sArray4[0] = LittleEndian.getShort(byArray, 12);
                sArray4[1] = LittleEndian.getShort(byArray, 14);
                sArray6[0] = LittleEndian.getShort(byArray, 16);
                sArray6[1] = LittleEndian.getShort(byArray, 18);
                sArray5[0] = LittleEndian.getShort(byArray, 20);
                sArray5[1] = LittleEndian.getShort(byArray, 22);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                tableProperties.setDyaRowHeight(n2);
                break;
            }
            case 8: {
                short[] sArray = new short[byArray[0] + 1];
                TCAbstractType[] tCAbstractTypeArray = new TableCellDescriptor[byArray[0]];
                int n8 = byArray[0];
                tableProperties.setItcMac((short)n8);
                tableProperties.setRgdxaCenter(sArray);
                tableProperties.setRgtc(tCAbstractTypeArray);
                for (int i = 0; i < n8; ++i) {
                    sArray[i] = LittleEndian.getShort(byArray, 1 + i * 2);
                    tCAbstractTypeArray[i] = TableCellDescriptor.convertBytesToTC(byArray, 1 + (n8 + 1) * 2 + i * 20);
                }
                sArray[n8] = LittleEndian.getShort(byArray, 1 + n8 * 2);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 32: {
                TCAbstractType[] tCAbstractTypeArray = tableProperties.getRgtc();
                for (int i = byArray[0]; i < byArray[1]; ++i) {
                    short[] sArray;
                    if ((byArray[2] & 8) > 0) {
                        sArray = tCAbstractTypeArray[i].getBrcRight();
                        sArray[0] = LittleEndian.getShort(byArray, 6);
                        sArray[1] = LittleEndian.getShort(byArray, 8);
                        continue;
                    }
                    if ((byArray[2] & 4) > 0) {
                        sArray = tCAbstractTypeArray[i].getBrcBottom();
                        sArray[0] = LittleEndian.getShort(byArray, 6);
                        sArray[1] = LittleEndian.getShort(byArray, 8);
                        continue;
                    }
                    if ((byArray[2] & 2) > 0) {
                        sArray = tCAbstractTypeArray[i].getBrcLeft();
                        sArray[0] = LittleEndian.getShort(byArray, 6);
                        sArray[1] = LittleEndian.getShort(byArray, 8);
                        continue;
                    }
                    if ((byArray[2] & 1) <= 0) continue;
                    sArray = tCAbstractTypeArray[i].getBrcTop();
                    sArray[0] = LittleEndian.getShort(byArray, 6);
                    sArray[1] = LittleEndian.getShort(byArray, 8);
                }
                break;
            }
            case 33: {
                int n9 = (n2 & 0xFF000000) >> 24;
                int n10 = (n2 & 0xFF0000) >> 16;
                int n11 = n2 & 0xFFFF;
                short s = tableProperties.getItcMac();
                short[] sArray = new short[s + n10 + 1];
                TableCellDescriptor[] tableCellDescriptorArray = new TableCellDescriptor[s + n10];
                if (n9 >= s) {
                    n9 = s;
                    System.arraycopy(tableProperties.getRgdxaCenter(), 0, sArray, 0, s + 1);
                    System.arraycopy(tableProperties.getRgtc(), 0, tableCellDescriptorArray, 0, s);
                } else {
                    System.arraycopy(tableProperties.getRgdxaCenter(), 0, sArray, 0, n9 + 1);
                    System.arraycopy(tableProperties.getRgdxaCenter(), n9 + 1, sArray, n9 + n10, s - n9);
                    System.arraycopy(tableProperties.getRgtc(), 0, tableCellDescriptorArray, 0, n9);
                    System.arraycopy(tableProperties.getRgtc(), n9, tableCellDescriptorArray, n9 + n10, s - n9);
                }
                for (int i = n9; i < n9 + n10; ++i) {
                    tableCellDescriptorArray[i] = new TableCellDescriptor();
                    sArray[i] = (short)(sArray[i - 1] + n11);
                }
                sArray[n9 + n10] = (short)(sArray[n9 + n10 - 1] + n11);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
        }
    }

    static void doSEPOperation(SectionProperties sectionProperties, int n, int n2, byte[] byArray) {
        switch (n) {
            case 0: {
                sectionProperties.setCnsPgn((byte)n2);
                break;
            }
            case 1: {
                sectionProperties.setIHeadingPgn((byte)n2);
                break;
            }
            case 2: {
                sectionProperties.setOlstAnm(byArray);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                sectionProperties.setFEvenlySpaced(StyleSheet.getFlag(n2));
                break;
            }
            case 6: {
                sectionProperties.setFUnlocked(StyleSheet.getFlag(n2));
                break;
            }
            case 7: {
                sectionProperties.setDmBinFirst((short)n2);
                break;
            }
            case 8: {
                sectionProperties.setDmBinOther((short)n2);
                break;
            }
            case 9: {
                sectionProperties.setBkc((byte)n2);
                break;
            }
            case 10: {
                sectionProperties.setFTitlePage(StyleSheet.getFlag(n2));
                break;
            }
            case 11: {
                sectionProperties.setCcolM1((short)n2);
                break;
            }
            case 12: {
                sectionProperties.setDxaColumns(n2);
                break;
            }
            case 13: {
                sectionProperties.setFAutoPgn(StyleSheet.getFlag(n2));
                break;
            }
            case 14: {
                sectionProperties.setNfcPgn((byte)n2);
                break;
            }
            case 15: {
                sectionProperties.setDyaPgn((short)n2);
                break;
            }
            case 16: {
                sectionProperties.setDxaPgn((short)n2);
                break;
            }
            case 17: {
                sectionProperties.setFPgnRestart(StyleSheet.getFlag(n2));
                break;
            }
            case 18: {
                sectionProperties.setFEndNote(StyleSheet.getFlag(n2));
                break;
            }
            case 19: {
                sectionProperties.setLnc((byte)n2);
                break;
            }
            case 20: {
                sectionProperties.setGrpfIhdt((byte)n2);
                break;
            }
            case 21: {
                sectionProperties.setNLnnMod((short)n2);
                break;
            }
            case 22: {
                sectionProperties.setDxaLnn(n2);
                break;
            }
            case 23: {
                sectionProperties.setDyaHdrTop(n2);
                break;
            }
            case 24: {
                sectionProperties.setDyaHdrBottom(n2);
                break;
            }
            case 25: {
                sectionProperties.setFLBetween(StyleSheet.getFlag(n2));
                break;
            }
            case 26: {
                sectionProperties.setVjc((byte)n2);
                break;
            }
            case 27: {
                sectionProperties.setLnnMin((short)n2);
                break;
            }
            case 28: {
                sectionProperties.setPgnStart((short)n2);
                break;
            }
            case 29: {
                sectionProperties.setDmOrientPage((byte)n2);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                sectionProperties.setXaPage(n2);
                break;
            }
            case 32: {
                sectionProperties.setYaPage(n2);
                break;
            }
            case 33: {
                sectionProperties.setDxaLeft(n2);
                break;
            }
            case 34: {
                sectionProperties.setDxaRight(n2);
                break;
            }
            case 35: {
                sectionProperties.setDyaTop(n2);
                break;
            }
            case 36: {
                sectionProperties.setDyaBottom(n2);
                break;
            }
            case 37: {
                sectionProperties.setDzaGutter(n2);
                break;
            }
            case 38: {
                sectionProperties.setDmPaperReq((short)n2);
                break;
            }
            case 39: {
                sectionProperties.setFPropMark(StyleSheet.getFlag(byArray[0]));
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                short[] sArray = sectionProperties.getBrcTop();
                sArray[0] = (short)(n2 & 0xFFFF);
                sArray[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 44: {
                short[] sArray = sectionProperties.getBrcLeft();
                sArray[0] = (short)(n2 & 0xFFFF);
                sArray[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 45: {
                short[] sArray = sectionProperties.getBrcBottom();
                sArray[0] = (short)(n2 & 0xFFFF);
                sArray[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 46: {
                short[] sArray = sectionProperties.getBrcRight();
                sArray[0] = (short)(n2 & 0xFFFF);
                sArray[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 47: {
                sectionProperties.setPgbProp(n2);
                break;
            }
            case 48: {
                sectionProperties.setDxtCharSpace(n2);
                break;
            }
            case 49: {
                sectionProperties.setDyaLinePitch(n2);
                break;
            }
            case 51: {
                sectionProperties.setWTextFlow((short)n2);
                break;
            }
        }
    }

    private static boolean getCHPFlag(byte by, boolean bl) {
        switch (by) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case -128: {
                return bl;
            }
            case -127: {
                return !bl;
            }
        }
        return false;
    }

    public static boolean getFlag(int n) {
        return n != 0;
    }
}

