/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdf.extractor;

import ai2.org.apache.poi.hdf.extractor.CHP;
import ai2.org.apache.poi.hdf.extractor.PAP;
import ai2.org.apache.poi.hdf.extractor.SEP;
import ai2.org.apache.poi.hdf.extractor.StyleDescription;
import ai2.org.apache.poi.hdf.extractor.TAP;
import ai2.org.apache.poi.hdf.extractor.TC;
import ai2.org.apache.poi.hdf.extractor.Utils;

@Deprecated
public final class StyleSheet {
    private static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    StyleDescription _nilStyle = new StyleDescription();
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] byArray) {
        int n;
        short s = Utils.convertBytesToShort(byArray, 0);
        int n2 = Utils.convertBytesToShort(byArray, 2);
        short s2 = Utils.convertBytesToShort(byArray, 4);
        int[] nArray = new int[]{Utils.convertBytesToInt(byArray, 14), Utils.convertBytesToInt(byArray, 18), Utils.convertBytesToInt(byArray, 22)};
        int n3 = 0;
        this._styleDescriptions = new StyleDescription[n2];
        for (n = 0; n < n2; ++n) {
            int n4 = 2 + s + n3;
            short s3 = Utils.convertBytesToShort(byArray, n4);
            if (s3 > 0) {
                StyleDescription styleDescription;
                byte[] byArray2 = new byte[s3];
                System.arraycopy(byArray, n4 += 2, byArray2, 0, s3);
                this._styleDescriptions[n] = styleDescription = new StyleDescription(byArray2, s2, true);
            }
            n3 += s3 + 2;
        }
        for (n = 0; n < this._styleDescriptions.length; ++n) {
            if (this._styleDescriptions[n] == null) continue;
            this.createPap(n);
            this.createChp(n);
        }
    }

    private void createPap(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        PAP pAP = styleDescription.getPAP();
        byte[] byArray = styleDescription.getPAPX();
        int n2 = styleDescription.getBaseStyle();
        if (pAP == null && byArray != null) {
            PAP pAP2 = this._nilStyle.getPAP();
            if (n2 != 4095 && (pAP2 = this._styleDescriptions[n2].getPAP()) == null) {
                this.createPap(n2);
                pAP2 = this._styleDescriptions[n2].getPAP();
            }
            pAP = (PAP)StyleSheet.uncompressProperty(byArray, pAP2, this);
            styleDescription.setPAP(pAP);
        }
    }

    private void createChp(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        CHP cHP = styleDescription.getCHP();
        byte[] byArray = styleDescription.getCHPX();
        int n2 = styleDescription.getBaseStyle();
        if (cHP == null && byArray != null) {
            CHP cHP2 = this._nilStyle.getCHP();
            if (n2 != 4095 && (cHP2 = this._styleDescriptions[n2].getCHP()) == null) {
                this.createChp(n2);
                cHP2 = this._styleDescriptions[n2].getCHP();
            }
            cHP = (CHP)StyleSheet.uncompressProperty(byArray, cHP2, this);
            styleDescription.setCHP(cHP);
        }
    }

    public StyleDescription getStyleDescription(int n) {
        return this._styleDescriptions[n];
    }

    static void doCHPOperation(CHP cHP, CHP cHP2, int n, int n2, byte[] byArray, byte[] byArray2, int n3, StyleSheet styleSheet) {
        switch (n) {
            case 0: {
                cHP2._fRMarkDel = StyleSheet.getFlag(n2);
                break;
            }
            case 1: {
                cHP2._fRMark = StyleSheet.getFlag(n2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                cHP2._fcPic = n2;
                cHP2._fSpec = true;
                break;
            }
            case 4: {
                cHP2._ibstRMark = (short)n2;
                break;
            }
            case 5: {
                cHP2._dttmRMark[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                cHP2._dttmRMark[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 6: {
                cHP2._fData = StyleSheet.getFlag(n2);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                short s = (short)((n2 & 0xFF0000) >>> 8);
                cHP2._fChsDiff = StyleSheet.getFlag(s);
                cHP2._chse = (short)(n2 & 0xFFFF);
                break;
            }
            case 9: {
                cHP2._fSpec = true;
                cHP2._ftcSym = Utils.convertBytesToShort(byArray, 0);
                cHP2._xchSym = Utils.convertBytesToShort(byArray, 2);
                break;
            }
            case 10: {
                cHP2._fOle2 = StyleSheet.getFlag(n2);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                cHP2._icoHighlight = (byte)n2;
                cHP2._highlighted = StyleSheet.getFlag(n2);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                cHP2._fcObj = n2;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                cHP2._istd = n2;
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                cHP2._bold = false;
                cHP2._italic = false;
                cHP2._fOutline = false;
                cHP2._fStrike = false;
                cHP2._fShadow = false;
                cHP2._fSmallCaps = false;
                cHP2._fCaps = false;
                cHP2._fVanish = false;
                cHP2._kul = 0;
                cHP2._ico = 0;
                break;
            }
            case 51: {
                cHP2.copy(cHP);
                return;
            }
            case 52: {
                break;
            }
            case 53: {
                cHP2._bold = StyleSheet.getCHPFlag((byte)n2, cHP._bold);
                break;
            }
            case 54: {
                cHP2._italic = StyleSheet.getCHPFlag((byte)n2, cHP._italic);
                break;
            }
            case 55: {
                cHP2._fStrike = StyleSheet.getCHPFlag((byte)n2, cHP._fStrike);
                break;
            }
            case 56: {
                cHP2._fOutline = StyleSheet.getCHPFlag((byte)n2, cHP._fOutline);
                break;
            }
            case 57: {
                cHP2._fShadow = StyleSheet.getCHPFlag((byte)n2, cHP._fShadow);
                break;
            }
            case 58: {
                cHP2._fSmallCaps = StyleSheet.getCHPFlag((byte)n2, cHP._fSmallCaps);
                break;
            }
            case 59: {
                cHP2._fCaps = StyleSheet.getCHPFlag((byte)n2, cHP._fCaps);
                break;
            }
            case 60: {
                cHP2._fVanish = StyleSheet.getCHPFlag((byte)n2, cHP._fVanish);
                break;
            }
            case 61: {
                cHP2._ftc = (short)n2;
                break;
            }
            case 62: {
                cHP2._kul = (byte)n2;
                break;
            }
            case 63: {
                boolean bl;
                byte by;
                byte by2;
                int n4 = n2 & 0xFF;
                if (n4 != 0) {
                    cHP2._hps = n4;
                }
                if ((by2 = (byte)((byte)(n2 & 0xFE00) >>> 4 >> 1)) != 0) {
                    cHP2._hps = Math.max(cHP2._hps + by2 * 2, 2);
                }
                if ((by = (byte)((n2 & 0xFF0000) >>> 8)) != 128) {
                    cHP2._hpsPos = by;
                }
                boolean bl2 = bl = (n2 & 0x100) > 0;
                if (bl && by != 128 && by != 0 && cHP._hpsPos == 0) {
                    cHP2._hps = Math.max(cHP2._hps + -2, 2);
                }
                if (!bl || by != 0 || cHP._hpsPos == 0) break;
                cHP2._hps = Math.max(cHP2._hps + 2, 2);
                break;
            }
            case 64: {
                cHP2._dxaSpace = n2;
                break;
            }
            case 65: {
                cHP2._lidDefault = (short)n2;
                break;
            }
            case 66: {
                cHP2._ico = (byte)n2;
                break;
            }
            case 67: {
                cHP2._hps = n2;
                break;
            }
            case 68: {
                byte by = (byte)n2;
                cHP2._hps = Math.max(cHP2._hps + by * 2, 2);
                break;
            }
            case 69: {
                cHP2._hpsPos = (short)n2;
                break;
            }
            case 70: {
                if (n2 != 0) {
                    if (cHP._hpsPos != 0) break;
                    cHP2._hps = Math.max(cHP2._hps + -2, 2);
                    break;
                }
                if (cHP._hpsPos == 0) break;
                cHP2._hps = Math.max(cHP2._hps + 2, 2);
                break;
            }
            case 71: {
                CHP cHP3 = new CHP();
                cHP3._ftc = (short)4;
                cHP3 = (CHP)StyleSheet.uncompressProperty(byArray, cHP3, styleSheet);
                CHP cHP4 = styleSheet.getStyleDescription(cHP._baseIstd).getCHP();
                if (cHP3._bold == cHP2._bold) {
                    cHP2._bold = cHP4._bold;
                }
                if (cHP3._italic == cHP2._italic) {
                    cHP2._italic = cHP4._italic;
                }
                if (cHP3._fSmallCaps == cHP2._fSmallCaps) {
                    cHP2._fSmallCaps = cHP4._fSmallCaps;
                }
                if (cHP3._fVanish == cHP2._fVanish) {
                    cHP2._fVanish = cHP4._fVanish;
                }
                if (cHP3._fStrike == cHP2._fStrike) {
                    cHP2._fStrike = cHP4._fStrike;
                }
                if (cHP3._fCaps == cHP2._fCaps) {
                    cHP2._fCaps = cHP4._fCaps;
                }
                if (cHP3._ftcAscii == cHP2._ftcAscii) {
                    cHP2._ftcAscii = cHP4._ftcAscii;
                }
                if (cHP3._ftcFE == cHP2._ftcFE) {
                    cHP2._ftcFE = cHP4._ftcFE;
                }
                if (cHP3._ftcOther == cHP2._ftcOther) {
                    cHP2._ftcOther = cHP4._ftcOther;
                }
                if (cHP3._hps == cHP2._hps) {
                    cHP2._hps = cHP4._hps;
                }
                if (cHP3._hpsPos == cHP2._hpsPos) {
                    cHP2._hpsPos = cHP4._hpsPos;
                }
                if (cHP3._kul == cHP2._kul) {
                    cHP2._kul = cHP4._kul;
                }
                if (cHP3._dxaSpace == cHP2._dxaSpace) {
                    cHP2._dxaSpace = cHP4._dxaSpace;
                }
                if (cHP3._ico == cHP2._ico) {
                    cHP2._ico = cHP4._ico;
                }
                if (cHP3._lidDefault == cHP2._lidDefault) {
                    cHP2._lidDefault = cHP4._lidDefault;
                }
                if (cHP3._lidFE != cHP2._lidFE) break;
                cHP2._lidFE = cHP4._lidFE;
                break;
            }
            case 72: {
                cHP2._iss = (byte)n2;
                break;
            }
            case 73: {
                cHP2._hps = Utils.convertBytesToShort(byArray, 0);
                break;
            }
            case 74: {
                short s = Utils.convertBytesToShort(byArray, 0);
                cHP2._hps = Math.max(cHP2._hps + s, 8);
                break;
            }
            case 75: {
                cHP2._hpsKern = n2;
                break;
            }
            case 76: {
                StyleSheet.doCHPOperation(cHP, cHP2, 71, n2, byArray, byArray2, n3, styleSheet);
                break;
            }
            case 77: {
                float f = (float)n2 / 100.0f;
                int n5 = (int)(f * (float)cHP2._hps);
                cHP2._hps += n5;
                break;
            }
            case 78: {
                cHP2._ysr = (byte)n2;
                break;
            }
            case 79: {
                cHP2._ftcAscii = (short)n2;
                break;
            }
            case 80: {
                cHP2._ftcFE = (short)n2;
                break;
            }
            case 81: {
                cHP2._ftcOther = (short)n2;
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                cHP2._fDStrike = StyleSheet.getFlag(n2);
                break;
            }
            case 84: {
                cHP2._fImprint = StyleSheet.getFlag(n2);
                break;
            }
            case 85: {
                cHP2._fSpec = StyleSheet.getFlag(n2);
                break;
            }
            case 86: {
                cHP2._fObj = StyleSheet.getFlag(n2);
                break;
            }
            case 87: {
                cHP2._fPropMark = StyleSheet.getFlag(byArray[0]);
                cHP2._ibstPropRMark = Utils.convertBytesToShort(byArray, 1);
                cHP2._dttmPropRMark = Utils.convertBytesToInt(byArray, 3);
                break;
            }
            case 88: {
                cHP2._fEmboss = StyleSheet.getFlag(n2);
                break;
            }
            case 89: {
                cHP2._sfxtText = (byte)n2;
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                break;
            }
            case 97: {
                break;
            }
            case 98: {
                cHP2._fDispFldRMark = StyleSheet.getFlag(byArray[0]);
                cHP2._ibstDispFldRMark = Utils.convertBytesToShort(byArray, 1);
                cHP2._dttmDispFldRMark = Utils.convertBytesToInt(byArray, 3);
                System.arraycopy(byArray, 7, cHP2._xstDispFldRMark, 0, 32);
                break;
            }
            case 99: {
                cHP2._ibstRMarkDel = (short)n2;
                break;
            }
            case 100: {
                cHP2._dttmRMarkDel[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                cHP2._dttmRMarkDel[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 101: {
                cHP2._brc[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                cHP2._brc[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 102: {
                cHP2._shd = (short)n2;
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                cHP2._lidDefault = (short)n2;
                break;
            }
            case 110: {
                cHP2._lidFE = (short)n2;
                break;
            }
            case 111: {
                cHP2._idctHint = (byte)n2;
            }
        }
    }

    static Object uncompressProperty(byte[] byArray, Object object, StyleSheet styleSheet) {
        return StyleSheet.uncompressProperty(byArray, object, styleSheet, true);
    }

    static Object uncompressProperty(byte[] byArray, Object object, StyleSheet styleSheet, boolean bl) {
        Object object2 = null;
        int n = 0;
        int n2 = 1;
        if (object instanceof PAP) {
            try {
                object2 = ((PAP)object).clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                ((PAP)object2)._istd = Utils.convertBytesToShort(byArray, 0);
                n = 2;
            }
        } else if (object instanceof CHP) {
            try {
                object2 = ((CHP)object).clone();
                ((CHP)object2)._baseIstd = ((CHP)object)._istd;
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = 2;
        } else if (object instanceof SEP) {
            object2 = object;
            n2 = 4;
        } else if (object instanceof TAP) {
            object2 = object;
            n2 = 5;
            n = 2;
        } else {
            return null;
        }
        while (n < byArray.length) {
            short s = Utils.convertBytesToShort(byArray, n);
            n += 2;
            byte by = (byte)((s & 0xE000) >> 13);
            int n3 = 0;
            int n4 = 0;
            byte[] byArray2 = null;
            switch (by) {
                case 0: 
                case 1: {
                    n3 = 1;
                    n4 = byArray[n];
                    break;
                }
                case 2: {
                    n3 = 2;
                    n4 = Utils.convertBytesToShort(byArray, n);
                    break;
                }
                case 3: {
                    n3 = 4;
                    n4 = Utils.convertBytesToInt(byArray, n);
                    break;
                }
                case 4: 
                case 5: {
                    n3 = 2;
                    n4 = Utils.convertBytesToShort(byArray, n);
                    break;
                }
                case 6: {
                    if (s != -10744) {
                        n3 = Utils.convertUnsignedByteToInt(byArray[n]);
                        ++n;
                    } else {
                        n3 = Utils.convertBytesToShort(byArray, n) - 1;
                        n += 2;
                    }
                    byArray2 = new byte[n3];
                    System.arraycopy(byArray, n, byArray2, 0, n3);
                    break;
                }
                case 7: {
                    n3 = 3;
                    n4 = Utils.convertBytesToInt((byte)0, byArray[n + 2], byArray[n + 1], byArray[n]);
                    break;
                }
                default: {
                    throw new RuntimeException("unrecognized pap opcode");
                }
            }
            n += n3;
            short s2 = (short)(s & 0x1FF);
            byte by2 = (byte)((s & 0x1C00) >> 10);
            switch (n2) {
                case 1: {
                    if (by2 != 1) break;
                    StyleSheet.doPAPOperation((PAP)object2, s2, n4, byArray2, byArray, n, by);
                    break;
                }
                case 2: {
                    StyleSheet.doCHPOperation((CHP)object, (CHP)object2, s2, n4, byArray2, byArray, n, styleSheet);
                    break;
                }
                case 4: {
                    StyleSheet.doSEPOperation((SEP)object2, s2, n4, byArray2);
                    break;
                }
                case 5: {
                    if (by2 != 5) break;
                    StyleSheet.doTAPOperation((TAP)object2, s2, n4, byArray2);
                }
            }
        }
        return object2;
    }

    static void doPAPOperation(PAP pAP, int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4) {
        switch (n) {
            case 0: {
                pAP._istd = n2;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (pAP._istd > 9 && pAP._istd < 1) break;
                pAP._istd += n2;
                if (n2 > 0) {
                    pAP._istd = Math.max(pAP._istd, 9);
                    break;
                }
                pAP._istd = Math.min(pAP._istd, 1);
                break;
            }
            case 3: {
                pAP._jc = (byte)n2;
                break;
            }
            case 4: {
                pAP._fSideBySide = (byte)n2;
                break;
            }
            case 5: {
                pAP._fKeep = (byte)n2;
                break;
            }
            case 6: {
                pAP._fKeepFollow = (byte)n2;
                break;
            }
            case 7: {
                pAP._fPageBreakBefore = (byte)n2;
                break;
            }
            case 8: {
                pAP._brcl = (byte)n2;
                break;
            }
            case 9: {
                pAP._brcp = (byte)n2;
                break;
            }
            case 10: {
                pAP._ilvl = (byte)n2;
                break;
            }
            case 11: {
                pAP._ilfo = n2;
                break;
            }
            case 12: {
                pAP._fNoLnn = (byte)n2;
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                pAP._dxaRight = n2;
                break;
            }
            case 15: {
                pAP._dxaLeft = n2;
                break;
            }
            case 16: {
                pAP._dxaLeft += n2;
                pAP._dxaLeft = Math.max(0, pAP._dxaLeft);
                break;
            }
            case 17: {
                pAP._dxaLeft1 = n2;
                break;
            }
            case 18: {
                pAP._lspd[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._lspd[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 19: {
                pAP._dyaBefore = n2;
                break;
            }
            case 20: {
                pAP._dyaAfter = n2;
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                pAP._fInTable = (byte)n2;
                break;
            }
            case 23: {
                pAP._fTtp = (byte)n2;
                break;
            }
            case 24: {
                pAP._dxaAbs = n2;
                break;
            }
            case 25: {
                pAP._dyaAbs = n2;
                break;
            }
            case 26: {
                pAP._dxaWidth = n2;
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                pAP._brcTop1 = (short)n2;
                break;
            }
            case 29: {
                pAP._brcLeft1 = (short)n2;
                break;
            }
            case 30: {
                pAP._brcBottom1 = (short)n2;
                break;
            }
            case 31: {
                pAP._brcRight1 = (short)n2;
                break;
            }
            case 32: {
                pAP._brcBetween1 = (short)n2;
                break;
            }
            case 33: {
                pAP._brcBar1 = (byte)n2;
                break;
            }
            case 34: {
                pAP._dxaFromText = n2;
                break;
            }
            case 35: {
                pAP._wr = (byte)n2;
                break;
            }
            case 36: {
                pAP._brcTop[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._brcTop[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 37: {
                pAP._brcLeft[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._brcLeft[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 38: {
                pAP._brcBottom[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._brcBottom[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 39: {
                pAP._brcRight[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._brcRight[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 40: {
                pAP._brcBetween[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._brcBetween[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 41: {
                pAP._brcBar[0] = Utils.convertBytesToShort(byArray2, n3 - 4);
                pAP._brcBar[1] = Utils.convertBytesToShort(byArray2, n3 - 2);
                break;
            }
            case 42: {
                pAP._fNoAutoHyph = (byte)n2;
                break;
            }
            case 43: {
                pAP._dyaHeight = n2;
                break;
            }
            case 44: {
                pAP._dcs = n2;
                break;
            }
            case 45: {
                pAP._shd = n2;
                break;
            }
            case 46: {
                pAP._dyaFromText = n2;
                break;
            }
            case 47: {
                pAP._dxaFromText = n2;
                break;
            }
            case 48: {
                pAP._fLocked = (byte)n2;
                break;
            }
            case 49: {
                pAP._fWindowControl = (byte)n2;
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                pAP._fKinsoku = (byte)n2;
                break;
            }
            case 52: {
                pAP._fWordWrap = (byte)n2;
                break;
            }
            case 53: {
                pAP._fOverflowPunct = (byte)n2;
                break;
            }
            case 54: {
                pAP._fTopLinePunct = (byte)n2;
                break;
            }
            case 55: {
                pAP._fAutoSpaceDE = (byte)n2;
                break;
            }
            case 56: {
                pAP._fAutoSpaceDN = (byte)n2;
                break;
            }
            case 57: {
                pAP._wAlignFont = n2;
                break;
            }
            case 58: {
                pAP._fontAlign = (short)n2;
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                pAP._anld = byArray;
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                break;
            }
            case 67: {
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (n4 != 6) break;
                pAP._numrm = byArray;
                break;
            }
            case 71: {
                pAP._fUsePgsuSettings = (byte)n2;
                break;
            }
            case 72: {
                pAP._fAdjustRight = (byte)n2;
                break;
            }
        }
    }

    static void doTAPOperation(TAP tAP, int n, int n2, byte[] byArray) {
        switch (n) {
            case 0: {
                tAP._jc = (short)n2;
                break;
            }
            case 1: {
                int n3 = n2 - (tAP._rgdxaCenter[0] + tAP._dxaGapHalf);
                int n4 = 0;
                while (n4 < tAP._itcMac) {
                    int n5 = n4++;
                    tAP._rgdxaCenter[n5] = (short)(tAP._rgdxaCenter[n5] + n3);
                }
                break;
            }
            case 2: {
                if (tAP._rgdxaCenter != null) {
                    int n6 = tAP._dxaGapHalf - n2;
                    tAP._rgdxaCenter[0] = (short)(tAP._rgdxaCenter[0] + n6);
                }
                tAP._dxaGapHalf = n2;
                break;
            }
            case 3: {
                tAP._fCantSplit = StyleSheet.getFlag(n2);
                break;
            }
            case 4: {
                tAP._fTableHeader = StyleSheet.getFlag(n2);
                break;
            }
            case 5: {
                tAP._brcTop[0] = Utils.convertBytesToShort(byArray, 0);
                tAP._brcTop[1] = Utils.convertBytesToShort(byArray, 2);
                tAP._brcLeft[0] = Utils.convertBytesToShort(byArray, 4);
                tAP._brcLeft[1] = Utils.convertBytesToShort(byArray, 6);
                tAP._brcBottom[0] = Utils.convertBytesToShort(byArray, 8);
                tAP._brcBottom[1] = Utils.convertBytesToShort(byArray, 10);
                tAP._brcRight[0] = Utils.convertBytesToShort(byArray, 12);
                tAP._brcRight[1] = Utils.convertBytesToShort(byArray, 14);
                tAP._brcHorizontal[0] = Utils.convertBytesToShort(byArray, 16);
                tAP._brcHorizontal[1] = Utils.convertBytesToShort(byArray, 18);
                tAP._brcVertical[0] = Utils.convertBytesToShort(byArray, 20);
                tAP._brcVertical[1] = Utils.convertBytesToShort(byArray, 22);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                tAP._dyaRowHeight = n2;
                break;
            }
            case 8: {
                tAP._itcMac = byArray[0];
                tAP._rgdxaCenter = new short[byArray[0] + 1];
                tAP._rgtc = new TC[byArray[0]];
                for (int i = 0; i < tAP._itcMac; ++i) {
                    tAP._rgdxaCenter[i] = Utils.convertBytesToShort(byArray, 1 + i * 2);
                    tAP._rgtc[i] = TC.convertBytesToTC(byArray, 1 + (byArray[0] + 1) * 2 + i * 20);
                }
                tAP._rgdxaCenter[tAP._itcMac] = Utils.convertBytesToShort(byArray, 1 + tAP._itcMac * 2);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 32: {
                for (int i = byArray[0]; i < byArray[1]; ++i) {
                    if ((byArray[2] & 8) > 0) {
                        tAP._rgtc[i]._brcRight[0] = Utils.convertBytesToShort(byArray, 6);
                        tAP._rgtc[i]._brcRight[1] = Utils.convertBytesToShort(byArray, 8);
                        continue;
                    }
                    if ((byArray[2] & 4) > 0) {
                        tAP._rgtc[i]._brcBottom[0] = Utils.convertBytesToShort(byArray, 6);
                        tAP._rgtc[i]._brcBottom[1] = Utils.convertBytesToShort(byArray, 8);
                        continue;
                    }
                    if ((byArray[2] & 2) > 0) {
                        tAP._rgtc[i]._brcLeft[0] = Utils.convertBytesToShort(byArray, 6);
                        tAP._rgtc[i]._brcLeft[1] = Utils.convertBytesToShort(byArray, 8);
                        continue;
                    }
                    if ((byArray[2] & 1) <= 0) continue;
                    tAP._rgtc[i]._brcTop[0] = Utils.convertBytesToShort(byArray, 6);
                    tAP._rgtc[i]._brcTop[1] = Utils.convertBytesToShort(byArray, 8);
                }
                break;
            }
            case 33: {
                int n7 = (n2 & 0xFF000000) >> 24;
                int n8 = (n2 & 0xFF0000) >> 16;
                int n9 = n2 & 0xFFFF;
                short[] sArray = new short[tAP._itcMac + n8 + 1];
                TC[] tCArray = new TC[tAP._itcMac + n8];
                if (n7 >= tAP._itcMac) {
                    n7 = tAP._itcMac;
                    System.arraycopy(tAP._rgdxaCenter, 0, sArray, 0, tAP._itcMac + 1);
                    System.arraycopy(tAP._rgtc, 0, tCArray, 0, tAP._itcMac);
                } else {
                    System.arraycopy(tAP._rgdxaCenter, 0, sArray, 0, n7 + 1);
                    System.arraycopy(tAP._rgdxaCenter, n7 + 1, sArray, n7 + n8, tAP._itcMac - n7);
                    System.arraycopy(tAP._rgtc, 0, tCArray, 0, n7);
                    System.arraycopy(tAP._rgtc, n7, tCArray, n7 + n8, tAP._itcMac - n7);
                }
                for (int i = n7; i < n7 + n8; ++i) {
                    tCArray[i] = new TC();
                    sArray[i] = (short)(sArray[i - 1] + n9);
                }
                sArray[n7 + n8] = (short)(sArray[n7 + n8 - 1] + n9);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
        }
    }

    static void doSEPOperation(SEP sEP, int n, int n2, byte[] byArray) {
        switch (n) {
            case 0: {
                sEP._cnsPgn = (byte)n2;
                break;
            }
            case 1: {
                sEP._iHeadingPgn = (byte)n2;
                break;
            }
            case 2: {
                sEP._olstAnn = byArray;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                sEP._fEvenlySpaced = StyleSheet.getFlag(n2);
                break;
            }
            case 6: {
                sEP._fUnlocked = StyleSheet.getFlag(n2);
                break;
            }
            case 7: {
                sEP._dmBinFirst = (short)n2;
                break;
            }
            case 8: {
                sEP._dmBinOther = (short)n2;
                break;
            }
            case 9: {
                sEP._bkc = (byte)n2;
                break;
            }
            case 10: {
                sEP._fTitlePage = StyleSheet.getFlag(n2);
                break;
            }
            case 11: {
                sEP._ccolM1 = (short)n2;
                break;
            }
            case 12: {
                sEP._dxaColumns = n2;
                break;
            }
            case 13: {
                sEP._fAutoPgn = StyleSheet.getFlag(n2);
                break;
            }
            case 14: {
                sEP._nfcPgn = (byte)n2;
                break;
            }
            case 15: {
                sEP._dyaPgn = (short)n2;
                break;
            }
            case 16: {
                sEP._dxaPgn = (short)n2;
                break;
            }
            case 17: {
                sEP._fPgnRestart = StyleSheet.getFlag(n2);
                break;
            }
            case 18: {
                sEP._fEndNote = StyleSheet.getFlag(n2);
                break;
            }
            case 19: {
                sEP._lnc = (byte)n2;
                break;
            }
            case 20: {
                sEP._grpfIhdt = (byte)n2;
                break;
            }
            case 21: {
                sEP._nLnnMod = (short)n2;
                break;
            }
            case 22: {
                sEP._dxaLnn = n2;
                break;
            }
            case 23: {
                sEP._dyaHdrTop = n2;
                break;
            }
            case 24: {
                sEP._dyaHdrBottom = n2;
                break;
            }
            case 25: {
                sEP._fLBetween = StyleSheet.getFlag(n2);
                break;
            }
            case 26: {
                sEP._vjc = (byte)n2;
                break;
            }
            case 27: {
                sEP._lnnMin = (short)n2;
                break;
            }
            case 28: {
                sEP._pgnStart = (short)n2;
                break;
            }
            case 29: {
                sEP._dmOrientPage = (byte)n2;
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                sEP._xaPage = n2;
                break;
            }
            case 32: {
                sEP._yaPage = n2;
                break;
            }
            case 33: {
                sEP._dxaLeft = n2;
                break;
            }
            case 34: {
                sEP._dxaRight = n2;
                break;
            }
            case 35: {
                sEP._dyaTop = n2;
                break;
            }
            case 36: {
                sEP._dyaBottom = n2;
                break;
            }
            case 37: {
                sEP._dzaGutter = n2;
                break;
            }
            case 38: {
                sEP._dmPaperReq = (short)n2;
                break;
            }
            case 39: {
                sEP._fPropMark = StyleSheet.getFlag(byArray[0]);
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                sEP._brcTop[0] = (short)(n2 & 0xFFFF);
                sEP._brcTop[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 44: {
                sEP._brcLeft[0] = (short)(n2 & 0xFFFF);
                sEP._brcLeft[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 45: {
                sEP._brcBottom[0] = (short)(n2 & 0xFFFF);
                sEP._brcBottom[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 46: {
                sEP._brcRight[0] = (short)(n2 & 0xFFFF);
                sEP._brcRight[1] = (short)((n2 & 0xFFFF0000) >> 16);
                break;
            }
            case 47: {
                sEP._pgbProp = (short)n2;
                break;
            }
            case 48: {
                sEP._dxtCharSpace = n2;
                break;
            }
            case 49: {
                sEP._dyaLinePitch = n2;
                break;
            }
            case 51: {
                sEP._wTextFlow = (short)n2;
                break;
            }
        }
    }

    private static boolean getCHPFlag(byte by, boolean bl) {
        switch (by) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case -128: {
                return bl;
            }
            case -127: {
                return !bl;
            }
        }
        return false;
    }

    public static boolean getFlag(int n) {
        return n != 0;
    }
}

