/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.dev;

import ai2.org.apache.poi.util.StringUtil;
import ai2.org.apache.poi.util.XMLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecordGenerator {
    public static void main(String[] stringArray) throws Exception {
        Class.forName("ai2.org.apache.poi.generator.FieldIterator");
        if (stringArray.length != 4) {
            System.out.println("Usage:");
            System.out.println("  java ai2.org.apache.poi.hssf.util.RecordGenerator RECORD_DEFINTIONS RECORD_STYLES DEST_SRC_PATH TEST_SRC_PATH");
        } else {
            RecordGenerator.generateRecords(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
    }

    private static void generateRecords(String string, String string2, String string3, String string4) throws Exception {
        File file = new File(string);
        for (int i = 0; i < file.listFiles().length; ++i) {
            File file2 = file.listFiles()[i];
            if (!file2.isFile() || !file2.getName().endsWith("_record.xml") && !file2.getName().endsWith("_type.xml")) continue;
            DocumentBuilderFactory documentBuilderFactory = XMLHelper.getDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file2);
            Element element = document.getDocumentElement();
            String string5 = element.getElementsByTagName("extends").item(0).getFirstChild().getNodeValue();
            String string6 = element.getElementsByTagName("suffix").item(0).getFirstChild().getNodeValue();
            String string7 = element.getAttributes().getNamedItem("name").getNodeValue();
            String string8 = element.getAttributes().getNamedItem("package").getNodeValue();
            string8 = string8.replace('.', '/');
            String string9 = string3 + "/" + string8;
            File file3 = new File(string9);
            file3.mkdirs();
            String string10 = string9 + "/" + string7 + string6 + ".java";
            RecordGenerator.transform(file2, new File(string10), new File(string2 + "/" + string5.toLowerCase(Locale.ROOT) + ".xsl"));
            System.out.println("Generated " + string6 + ": " + string10);
            string9 = string4 + "/" + string8;
            file3 = new File(string9);
            file3.mkdirs();
            string10 = string9 + "/Test" + string7 + string6 + ".java";
            if (!new File(string10).exists()) {
                String string11 = string2 + "/" + string5.toLowerCase(Locale.ROOT) + "_test.xsl";
                RecordGenerator.transform(file2, new File(string10), new File(string11));
                System.out.println("Generated test: " + string10);
                continue;
            }
            System.out.println("Skipped test generation: " + string10);
        }
    }

    private static void transform(File file, File file2, File file3) throws FileNotFoundException, TransformerException {
        Transformer transformer;
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file3), StringUtil.UTF8);
        StreamSource streamSource = new StreamSource(inputStreamReader);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer(streamSource);
        }
        catch (TransformerException transformerException) {
            System.err.println("Error compiling XSL style sheet " + file3);
            throw transformerException;
        }
        Properties properties = new Properties();
        properties.setProperty("method", "text");
        transformer.setOutputProperties(properties);
        StreamResult streamResult = new StreamResult(file2);
        transformer.transform(new StreamSource(file), streamResult);
    }
}

