/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.dev;

import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class OOXMLLister {
    private OPCPackage container;
    private PrintStream disp;

    public OOXMLLister(OPCPackage oPCPackage) {
        this(oPCPackage, System.out);
    }

    public OOXMLLister(OPCPackage oPCPackage, PrintStream printStream) {
        this.container = oPCPackage;
        this.disp = printStream;
    }

    public static long getSize(PackagePart packagePart) throws IOException {
        InputStream inputStream = packagePart.getInputStream();
        byte[] byArray = new byte[8192];
        long l = 0L;
        int n = 0;
        while (n > -1) {
            n = inputStream.read(byArray);
            if (n <= 0) continue;
            l += (long)n;
        }
        return l;
    }

    public void displayParts() throws Exception {
        ArrayList<PackagePart> arrayList = this.container.getParts();
        for (PackagePart packagePart : arrayList) {
            this.disp.println(packagePart.getPartName());
            this.disp.println("\t" + packagePart.getContentType());
            if (!packagePart.getPartName().toString().equals("/docProps/core.xml")) {
                this.disp.println("\t" + OOXMLLister.getSize(packagePart) + " bytes");
            }
            if (packagePart.isRelationshipPart()) continue;
            this.disp.println("\t" + packagePart.getRelationships().size() + " relations");
            for (PackageRelationship packageRelationship : packagePart.getRelationships()) {
                this.displayRelation(packageRelationship, "\t  ");
            }
        }
    }

    public void displayRelations() throws Exception {
        PackageRelationshipCollection packageRelationshipCollection = this.container.getRelationships();
        for (PackageRelationship packageRelationship : packageRelationshipCollection) {
            this.displayRelation(packageRelationship, "");
        }
    }

    private void displayRelation(PackageRelationship packageRelationship, String string) {
        this.disp.println(string + "Relationship:");
        this.disp.println(string + "\tFrom: " + packageRelationship.getSourceURI());
        this.disp.println(string + "\tTo:   " + packageRelationship.getTargetURI());
        this.disp.println(string + "\tID:   " + packageRelationship.getId());
        this.disp.println(string + "\tMode: " + (Object)((Object)packageRelationship.getTargetMode()));
        this.disp.println(string + "\tType: " + packageRelationship.getRelationshipType());
    }

    public static void main(String[] stringArray) throws Exception {
        File file;
        if (stringArray.length == 0) {
            System.err.println("Use:");
            System.err.println("\tjava OOXMLLister <filename>");
            System.exit(1);
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println("Error, file not found!");
            System.err.println("\t" + file.toString());
            System.exit(2);
        }
        OOXMLLister oOXMLLister = new OOXMLLister(OPCPackage.open(file.toString(), PackageAccess.READ));
        oOXMLLister.disp.println(file.toString() + "\n");
        oOXMLLister.displayParts();
        oOXMLLister.disp.println();
        oOXMLLister.displayRelations();
    }
}

