/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.RecordFormatException;

public class EscherTextboxRecord
extends EscherRecord {
    public static final short RECORD_ID = -4083;
    public static final String RECORD_DESCRIPTION = "msofbtClientTextbox";
    private static final byte[] NO_BYTES = new byte[0];
    private byte[] thedata = NO_BYTES;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        this.thedata = new byte[n2];
        System.arraycopy(byArray, n + 8, this.thedata, 0, n2);
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = this.thedata.length;
        LittleEndian.putInt(byArray, n + 4, n2);
        System.arraycopy(this.thedata, 0, byArray, n + 8, this.thedata.length);
        int n3 = n + 8 + this.thedata.length;
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        int n4 = n3 - n;
        if (n4 != this.getRecordSize()) {
            throw new RecordFormatException(n4 + " bytes written but getRecordSize() reports " + this.getRecordSize());
        }
        return n4;
    }

    public byte[] getData() {
        return this.thedata;
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.thedata = new byte[n2];
        System.arraycopy(byArray, n, this.thedata, 0, n2);
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray.length);
    }

    public int getRecordSize() {
        return 8 + this.thedata.length;
    }

    public Object clone() {
        return super.clone();
    }

    public String getRecordName() {
        return "ClientTextbox";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "";
        try {
            if (this.thedata.length != 0) {
                string2 = "  Extra Data:" + string;
                string2 = string2 + HexDump.dump(this.thedata, 0L, 0);
            }
        }
        catch (Exception exception) {
            string2 = "Error!!";
        }
        return this.getClass().getName() + ":" + string + "  isContainer: " + this.isContainerRecord() + string + "  version: 0x" + HexDump.toHex(this.getVersion()) + string + "  instance: 0x" + HexDump.toHex(this.getInstance()) + string + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + string + "  numchildren: " + this.getChildRecords().size() + string + string2;
    }

    public String toXml(String string) {
        String string2 = "";
        try {
            if (this.thedata.length != 0) {
                string2 = string2 + HexDump.dump(this.thedata, 0L, 0);
            }
        }
        catch (Exception exception) {
            string2 = "Error!!";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<ExtraData>").append(string2).append("</ExtraData>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }
}

