/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;

public class EscherSpRecord
extends EscherRecord {
    public static final short RECORD_ID = -4086;
    public static final String RECORD_DESCRIPTION = "MsofbtSp";
    public static final int FLAG_GROUP = 1;
    public static final int FLAG_CHILD = 2;
    public static final int FLAG_PATRIARCH = 4;
    public static final int FLAG_DELETED = 8;
    public static final int FLAG_OLESHAPE = 16;
    public static final int FLAG_HAVEMASTER = 32;
    public static final int FLAG_FLIPHORIZ = 64;
    public static final int FLAG_FLIPVERT = 128;
    public static final int FLAG_CONNECTOR = 256;
    public static final int FLAG_HAVEANCHOR = 512;
    public static final int FLAG_BACKGROUND = 1024;
    public static final int FLAG_HASSHAPETYPE = 2048;
    private int field_1_shapeId;
    private int field_2_flags;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        this.readHeader(byArray, n);
        int n2 = n + 8;
        int n3 = 0;
        this.field_1_shapeId = LittleEndian.getInt(byArray, n2 + n3);
        this.field_2_flags = LittleEndian.getInt(byArray, n2 + (n3 += 4));
        n3 += 4;
        return this.getRecordSize();
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = 8;
        LittleEndian.putInt(byArray, n + 4, n2);
        LittleEndian.putInt(byArray, n + 8, this.field_1_shapeId);
        LittleEndian.putInt(byArray, n + 12, this.field_2_flags);
        escherSerializationListener.afterRecordSerialize(n + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), this);
        return 16;
    }

    public int getRecordSize() {
        return 16;
    }

    public short getRecordId() {
        return -4086;
    }

    public String getRecordName() {
        return "Sp";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4086) + string + "  Version: 0x" + HexDump.toHex(this.getVersion()) + string + "  ShapeType: 0x" + HexDump.toHex(this.getShapeType()) + string + "  ShapeId: " + this.field_1_shapeId + string + "  Flags: " + this.decodeFlags(this.field_2_flags) + " (0x" + HexDump.toHex(this.field_2_flags) + ")" + string;
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<ShapeType>0x").append(HexDump.toHex(this.getShapeType())).append("</ShapeType>\n").append(string).append("\t").append("<ShapeId>").append(this.field_1_shapeId).append("</ShapeId>\n").append(string).append("\t").append("<Flags>").append(this.decodeFlags(this.field_2_flags) + " (0x" + HexDump.toHex(this.field_2_flags) + ")").append("</Flags>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    private String decodeFlags(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((n & 1) != 0 ? "|GROUP" : "");
        stringBuffer.append((n & 2) != 0 ? "|CHILD" : "");
        stringBuffer.append((n & 4) != 0 ? "|PATRIARCH" : "");
        stringBuffer.append((n & 8) != 0 ? "|DELETED" : "");
        stringBuffer.append((n & 0x10) != 0 ? "|OLESHAPE" : "");
        stringBuffer.append((n & 0x20) != 0 ? "|HAVEMASTER" : "");
        stringBuffer.append((n & 0x40) != 0 ? "|FLIPHORIZ" : "");
        stringBuffer.append((n & 0x80) != 0 ? "|FLIPVERT" : "");
        stringBuffer.append((n & 0x100) != 0 ? "|CONNECTOR" : "");
        stringBuffer.append((n & 0x200) != 0 ? "|HAVEANCHOR" : "");
        stringBuffer.append((n & 0x400) != 0 ? "|BACKGROUND" : "");
        stringBuffer.append((n & 0x800) != 0 ? "|HASSHAPETYPE" : "");
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    public int getShapeId() {
        return this.field_1_shapeId;
    }

    public void setShapeId(int n) {
        this.field_1_shapeId = n;
    }

    public int getFlags() {
        return this.field_2_flags;
    }

    public void setFlags(int n) {
        this.field_2_flags = n;
    }

    public short getShapeType() {
        return this.getInstance();
    }

    public void setShapeType(short s) {
        this.setInstance(s);
    }
}

