/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.ddf.NullEscherSerializationListener;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EscherRecord {
    private static BitField fInstance = BitFieldFactory.getInstance(65520);
    private static BitField fVersion = BitFieldFactory.getInstance(15);
    private short _options;
    private short _recordId;

    protected int fillFields(byte[] byArray, EscherRecordFactory escherRecordFactory) {
        return this.fillFields(byArray, 0, escherRecordFactory);
    }

    public abstract int fillFields(byte[] var1, int var2, EscherRecordFactory var3);

    protected int readHeader(byte[] byArray, int n) {
        this._options = LittleEndian.getShort(byArray, n);
        this._recordId = LittleEndian.getShort(byArray, n + 2);
        int n2 = LittleEndian.getInt(byArray, n + 4);
        return n2;
    }

    protected static short readInstance(byte[] byArray, int n) {
        short s = LittleEndian.getShort(byArray, n);
        return fInstance.getShortValue(s);
    }

    public boolean isContainerRecord() {
        return this.getVersion() == 15;
    }

    @Internal
    public short getOptions() {
        return this._options;
    }

    @Internal
    public void setOptions(short s) {
        this.setVersion(fVersion.getShortValue(s));
        this.setInstance(fInstance.getShortValue(s));
        this._options = s;
    }

    public byte[] serialize() {
        byte[] byArray = new byte[this.getRecordSize()];
        this.serialize(0, byArray);
        return byArray;
    }

    public int serialize(int n, byte[] byArray) {
        return this.serialize(n, byArray, new NullEscherSerializationListener());
    }

    public abstract int serialize(int var1, byte[] var2, EscherSerializationListener var3);

    public abstract int getRecordSize();

    public short getRecordId() {
        return this._recordId;
    }

    public void setRecordId(short s) {
        this._recordId = s;
    }

    public List<EscherRecord> getChildRecords() {
        return Collections.emptyList();
    }

    public void setChildRecords(List<EscherRecord> list) {
        throw new UnsupportedOperationException("This record does not support child records.");
    }

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public EscherRecord getChild(int n) {
        return this.getChildRecords().get(n);
    }

    public void display(PrintWriter printWriter, int n) {
        for (int i = 0; i < n * 4; ++i) {
            printWriter.print(' ');
        }
        printWriter.println(this.getRecordName());
    }

    public abstract String getRecordName();

    public short getInstance() {
        return fInstance.getShortValue(this._options);
    }

    public void setInstance(short s) {
        this._options = fInstance.setShortValue(this._options, s);
    }

    public short getVersion() {
        return fVersion.getShortValue(this._options);
    }

    public void setVersion(short s) {
        this._options = fVersion.setShortValue(this._options, s);
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("<").append(this.getClass().getSimpleName()).append(">\n").append(string).append("\t").append("<RecordId>0x").append(HexDump.toHex(this._recordId)).append("</RecordId>\n").append(string).append("\t").append("<Options>").append(this._options).append("</Options>\n").append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    protected String formatXmlRecordHeader(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string).append(" recordId=\"0x").append(string2).append("\" version=\"0x").append(string3).append("\" instance=\"0x").append(string4).append("\" size=\"").append(this.getRecordSize()).append("\">\n");
        return stringBuilder.toString();
    }

    public String toXml() {
        return this.toXml("");
    }
}

