/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;

public class EscherClientDataRecord
extends EscherRecord {
    public static final short RECORD_ID = -4079;
    public static final String RECORD_DESCRIPTION = "MsofbtClientData";
    private byte[] remainingData;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        this.remainingData = new byte[n2];
        System.arraycopy(byArray, n3, this.remainingData, 0, n2);
        return 8 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        if (this.remainingData == null) {
            this.remainingData = new byte[0];
        }
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, this.remainingData.length);
        System.arraycopy(this.remainingData, 0, byArray, n + 8, this.remainingData.length);
        int n2 = n + 8 + this.remainingData.length;
        escherSerializationListener.afterRecordSerialize(n2, this.getRecordId(), n2 - n, this);
        return n2 - n;
    }

    public int getRecordSize() {
        return 8 + (this.remainingData == null ? 0 : this.remainingData.length);
    }

    public short getRecordId() {
        return -4079;
    }

    public String getRecordName() {
        return "ClientData";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = HexDump.dump(this.remainingData, 0L, 0);
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4079) + string + "  Version: 0x" + HexDump.toHex(this.getVersion()) + string + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + string + "  Extra Data:" + string + string2;
    }

    public String toXml(String string) {
        String string2 = HexDump.dump(this.remainingData, 0L, 0).trim();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<ExtraData>").append(string2).append("</ExtraData>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public byte[] getRemainingData() {
        return this.remainingData;
    }

    public void setRemainingData(byte[] byArray) {
        this.remainingData = byArray;
    }
}

