/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;

public class EscherClientAnchorRecord
extends EscherRecord {
    public static final short RECORD_ID = -4080;
    public static final String RECORD_DESCRIPTION = "MsofbtClientAnchor";
    private short field_1_flag;
    private short field_2_col1;
    private short field_3_dx1;
    private short field_4_row1;
    private short field_5_dy1;
    private short field_6_col2;
    private short field_7_dx2;
    private short field_8_row2;
    private short field_9_dy2;
    private byte[] remainingData;
    private boolean shortRecord = false;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        if (n2 != 4) {
            this.field_1_flag = LittleEndian.getShort(byArray, n3 + n4);
            this.field_2_col1 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
            this.field_3_dx1 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
            this.field_4_row1 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
            n4 += 2;
            if (n2 >= 18) {
                this.field_5_dy1 = LittleEndian.getShort(byArray, n3 + n4);
                this.field_6_col2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                this.field_7_dx2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                this.field_8_row2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                this.field_9_dy2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                n4 += 2;
                this.shortRecord = false;
            } else {
                this.shortRecord = true;
            }
        }
        this.remainingData = new byte[n2 -= n4];
        System.arraycopy(byArray, n3 + n4, this.remainingData, 0, n2);
        return 8 + n4 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        if (this.remainingData == null) {
            this.remainingData = new byte[0];
        }
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = this.remainingData.length + (this.shortRecord ? 8 : 18);
        LittleEndian.putInt(byArray, n + 4, n2);
        LittleEndian.putShort(byArray, n + 8, this.field_1_flag);
        LittleEndian.putShort(byArray, n + 10, this.field_2_col1);
        LittleEndian.putShort(byArray, n + 12, this.field_3_dx1);
        LittleEndian.putShort(byArray, n + 14, this.field_4_row1);
        if (!this.shortRecord) {
            LittleEndian.putShort(byArray, n + 16, this.field_5_dy1);
            LittleEndian.putShort(byArray, n + 18, this.field_6_col2);
            LittleEndian.putShort(byArray, n + 20, this.field_7_dx2);
            LittleEndian.putShort(byArray, n + 22, this.field_8_row2);
            LittleEndian.putShort(byArray, n + 24, this.field_9_dy2);
        }
        System.arraycopy(this.remainingData, 0, byArray, n + (this.shortRecord ? 16 : 26), this.remainingData.length);
        int n3 = n + 8 + (this.shortRecord ? 8 : 18) + this.remainingData.length;
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    public int getRecordSize() {
        return 8 + (this.shortRecord ? 8 : 18) + (this.remainingData == null ? 0 : this.remainingData.length);
    }

    public short getRecordId() {
        return -4080;
    }

    public String getRecordName() {
        return "ClientAnchor";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = HexDump.dump(this.remainingData, 0L, 0);
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4080) + string + "  Version: 0x" + HexDump.toHex(this.getVersion()) + string + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + string + "  Flag: " + this.field_1_flag + string + "  Col1: " + this.field_2_col1 + string + "  DX1: " + this.field_3_dx1 + string + "  Row1: " + this.field_4_row1 + string + "  DY1: " + this.field_5_dy1 + string + "  Col2: " + this.field_6_col2 + string + "  DX2: " + this.field_7_dx2 + string + "  Row2: " + this.field_8_row2 + string + "  DY2: " + this.field_9_dy2 + string + "  Extra Data:" + string + string2;
    }

    public String toXml(String string) {
        String string2 = HexDump.dump(this.remainingData, 0L, 0).trim();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<Flag>").append(this.field_1_flag).append("</Flag>\n").append(string).append("\t").append("<Col1>").append(this.field_2_col1).append("</Col1>\n").append(string).append("\t").append("<DX1>").append(this.field_3_dx1).append("</DX1>\n").append(string).append("\t").append("<Row1>").append(this.field_4_row1).append("</Row1>\n").append(string).append("\t").append("<DY1>").append(this.field_5_dy1).append("</DY1>\n").append(string).append("\t").append("<Col2>").append(this.field_6_col2).append("</Col2>\n").append(string).append("\t").append("<DX2>").append(this.field_7_dx2).append("</DX2>\n").append(string).append("\t").append("<Row2>").append(this.field_8_row2).append("</Row2>\n").append(string).append("\t").append("<DY2>").append(this.field_9_dy2).append("</DY2>\n").append(string).append("\t").append("<ExtraData>").append(string2).append("</ExtraData>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public short getFlag() {
        return this.field_1_flag;
    }

    public void setFlag(short s) {
        this.field_1_flag = s;
    }

    public short getCol1() {
        return this.field_2_col1;
    }

    public void setCol1(short s) {
        this.field_2_col1 = s;
    }

    public short getDx1() {
        return this.field_3_dx1;
    }

    public void setDx1(short s) {
        this.field_3_dx1 = s;
    }

    public short getRow1() {
        return this.field_4_row1;
    }

    public void setRow1(short s) {
        this.field_4_row1 = s;
    }

    public short getDy1() {
        return this.field_5_dy1;
    }

    public void setDy1(short s) {
        this.shortRecord = false;
        this.field_5_dy1 = s;
    }

    public short getCol2() {
        return this.field_6_col2;
    }

    public void setCol2(short s) {
        this.shortRecord = false;
        this.field_6_col2 = s;
    }

    public short getDx2() {
        return this.field_7_dx2;
    }

    public void setDx2(short s) {
        this.shortRecord = false;
        this.field_7_dx2 = s;
    }

    public short getRow2() {
        return this.field_8_row2;
    }

    public void setRow2(short s) {
        this.shortRecord = false;
        this.field_8_row2 = s;
    }

    public short getDy2() {
        return this.field_9_dy2;
    }

    public void setDy2(short s) {
        this.shortRecord = false;
        this.field_9_dy2 = s;
    }

    public byte[] getRemainingData() {
        return this.remainingData;
    }

    public void setRemainingData(byte[] byArray) {
        this.remainingData = byArray;
    }
}

