/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherBlipRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;

public class EscherBitmapBlip
extends EscherBlipRecord {
    public static final short RECORD_ID_JPEG = -4067;
    public static final short RECORD_ID_PNG = -4066;
    public static final short RECORD_ID_DIB = -4065;
    private static final int HEADER_SIZE = 8;
    private byte[] field_1_UID;
    private byte field_2_marker = (byte)-1;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        this.field_1_UID = new byte[16];
        System.arraycopy(byArray, n3, this.field_1_UID, 0, 16);
        this.field_2_marker = byArray[n3 += 16];
        this.field_pictureData = new byte[n2 - 17];
        System.arraycopy(byArray, ++n3, this.field_pictureData, 0, this.field_pictureData.length);
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, this.getRecordSize() - 8);
        int n2 = n + 8;
        System.arraycopy(this.field_1_UID, 0, byArray, n2, 16);
        byArray[n2 + 16] = this.field_2_marker;
        System.arraycopy(this.field_pictureData, 0, byArray, n2 + 17, this.field_pictureData.length);
        escherSerializationListener.afterRecordSerialize(n + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), this);
        return 25 + this.field_pictureData.length;
    }

    public int getRecordSize() {
        return 25 + this.field_pictureData.length;
    }

    public byte[] getUID() {
        return this.field_1_UID;
    }

    public void setUID(byte[] byArray) {
        this.field_1_UID = byArray;
    }

    public byte getMarker() {
        return this.field_2_marker;
    }

    public void setMarker(byte by) {
        this.field_2_marker = by;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = HexDump.dump(this.field_pictureData, 0L, 0);
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + string + "  Version: 0x" + HexDump.toHex(this.getVersion()) + string + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + string + "  UID: 0x" + HexDump.toHex(this.field_1_UID) + string + "  Marker: 0x" + HexDump.toHex(this.field_2_marker) + string + "  Extra Data:" + string + string2;
    }

    public String toXml(String string) {
        String string2 = HexDump.dump(this.field_pictureData, 0L, 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<UID>0x").append(HexDump.toHex(this.field_1_UID)).append("</UID>\n").append(string).append("\t").append("<Marker>0x").append(HexDump.toHex(this.field_2_marker)).append("</Marker>\n").append(string).append("\t").append("<ExtraData>").append(string2).append("</ExtraData>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }
}

