/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherComplexProperty;
import ai2.org.apache.poi.ddf.EscherProperties;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EscherArrayProperty
extends EscherComplexProperty
implements Iterable<byte[]> {
    private static final int FIXED_SIZE = 6;
    private boolean sizeIncludesHeaderSize = true;
    private boolean emptyComplexPart = false;

    public EscherArrayProperty(short s, byte[] byArray) {
        super(s, EscherArrayProperty.checkComplexData(byArray));
        this.emptyComplexPart = byArray.length == 0;
    }

    public EscherArrayProperty(short s, boolean bl, byte[] byArray) {
        super(s, bl, EscherArrayProperty.checkComplexData(byArray));
    }

    private static byte[] checkComplexData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return new byte[6];
        }
        return byArray;
    }

    public int getNumberOfElementsInArray() {
        if (this.emptyComplexPart) {
            return 0;
        }
        return LittleEndian.getUShort(this._complexData, 0);
    }

    public void setNumberOfElementsInArray(int n) {
        int n2 = n * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (n2 != this._complexData.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this._complexData, 0, byArray, 0, this._complexData.length);
            this._complexData = byArray;
        }
        LittleEndian.putShort(this._complexData, 0, (short)n);
    }

    public int getNumberOfElementsInMemory() {
        return LittleEndian.getUShort(this._complexData, 2);
    }

    public void setNumberOfElementsInMemory(int n) {
        int n2 = n * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (n2 != this._complexData.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this._complexData, 0, byArray, 0, n2);
            this._complexData = byArray;
        }
        LittleEndian.putShort(this._complexData, 2, (short)n);
    }

    public short getSizeOfElements() {
        return LittleEndian.getShort(this._complexData, 4);
    }

    public void setSizeOfElements(int n) {
        LittleEndian.putShort(this._complexData, 4, (short)n);
        int n2 = this.getNumberOfElementsInArray() * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (n2 != this._complexData.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this._complexData, 0, byArray, 0, 6);
            this._complexData = byArray;
        }
    }

    public byte[] getElement(int n) {
        int n2 = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        byte[] byArray = new byte[n2];
        System.arraycopy(this._complexData, 6 + n * n2, byArray, 0, byArray.length);
        return byArray;
    }

    public void setElement(int n, byte[] byArray) {
        int n2 = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        System.arraycopy(byArray, 0, this._complexData, 6 + n * n2, n2);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    {EscherArrayProperty:\n");
        stringBuffer.append("     Num Elements: " + this.getNumberOfElementsInArray() + '\n');
        stringBuffer.append("     Num Elements In Memory: " + this.getNumberOfElementsInMemory() + '\n');
        stringBuffer.append("     Size of elements: " + this.getSizeOfElements() + '\n');
        for (int i = 0; i < this.getNumberOfElementsInArray(); ++i) {
            stringBuffer.append("     Element " + i + ": " + HexDump.toHex(this.getElement(i)) + '\n');
        }
        stringBuffer.append("}\n");
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + '\n' + stringBuffer.toString();
    }

    @Override
    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("<").append(this.getClass().getSimpleName()).append(" id=\"0x").append(HexDump.toHex(this.getId())).append("\" name=\"").append(this.getName()).append("\" blipId=\"").append(this.isBlipId()).append("\">\n");
        for (int i = 0; i < this.getNumberOfElementsInArray(); ++i) {
            stringBuilder.append("\t").append(string).append("<Element>").append(HexDump.toHex(this.getElement(i))).append("</Element>\n");
        }
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public int setArrayData(byte[] byArray, int n) {
        if (this.emptyComplexPart) {
            this._complexData = new byte[0];
        } else {
            short s = LittleEndian.getShort(byArray, n);
            LittleEndian.getShort(byArray, n + 2);
            short s2 = LittleEndian.getShort(byArray, n + 4);
            int n2 = EscherArrayProperty.getActualSizeOfElements(s2) * s;
            if (n2 == this._complexData.length) {
                this._complexData = new byte[n2 + 6];
                this.sizeIncludesHeaderSize = false;
            }
            System.arraycopy(byArray, n, this._complexData, 0, this._complexData.length);
        }
        return this._complexData.length;
    }

    @Override
    public int serializeSimplePart(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this.getId());
        int n2 = this._complexData.length;
        if (!this.sizeIncludesHeaderSize) {
            n2 -= 6;
        }
        LittleEndian.putInt(byArray, n + 2, n2);
        return 6;
    }

    public static int getActualSizeOfElements(short s) {
        if (s < 0) {
            return (short)(-s >> 2);
        }
        return s;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < EscherArrayProperty.this.getNumberOfElementsInArray();
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return EscherArrayProperty.this.getElement(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }
}

