/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import ai2.org.apache.poi.openxml4j.util.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.PropertiesDocument;

public class POIXMLProperties {
    private OPCPackage pkg;
    private CoreProperties core;
    private ExtendedProperties ext;
    private CustomProperties cust;
    private PackagePart extPart;
    private PackagePart custPart;
    private static final PropertiesDocument NEW_EXT_INSTANCE = PropertiesDocument.Factory.newInstance();
    private static final org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument NEW_CUST_INSTANCE;

    public POIXMLProperties(OPCPackage oPCPackage) throws IOException, OpenXML4JException, XmlException {
        Object object;
        this.pkg = oPCPackage;
        this.core = new CoreProperties((PackagePropertiesPart)this.pkg.getPackageProperties());
        PackageRelationshipCollection packageRelationshipCollection = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        if (packageRelationshipCollection.size() == 1) {
            this.extPart = this.pkg.getPart(packageRelationshipCollection.getRelationship(0));
            object = PropertiesDocument.Factory.parse((InputStream)this.extPart.getInputStream());
            this.ext = new ExtendedProperties((PropertiesDocument)object);
        } else {
            this.extPart = null;
            this.ext = new ExtendedProperties((PropertiesDocument)NEW_EXT_INSTANCE.copy());
        }
        object = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
        if (((PackageRelationshipCollection)object).size() == 1) {
            this.custPart = this.pkg.getPart(((PackageRelationshipCollection)object).getRelationship(0));
            org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument propertiesDocument = PropertiesDocument.Factory.parse((InputStream)this.custPart.getInputStream());
            this.cust = new CustomProperties(propertiesDocument);
        } else {
            this.custPart = null;
            this.cust = new CustomProperties((org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument)NEW_CUST_INSTANCE.copy());
        }
    }

    public CoreProperties getCoreProperties() {
        return this.core;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.ext;
    }

    public CustomProperties getCustomProperties() {
        return this.cust;
    }

    public void commit() throws IOException {
        OutputStream outputStream;
        HashMap<String, String> hashMap;
        Object object;
        if (this.extPart == null && !NEW_EXT_INSTANCE.toString().equals(this.ext.props.toString())) {
            try {
                object = PackagingURIHelper.createPartName("/docProps/app.xml");
                this.pkg.addRelationship((PackagePartName)object, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
                this.extPart = this.pkg.createPart((PackagePartName)object, "application/vnd.openxmlformats-officedocument.extended-properties+xml");
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new POIXMLException(invalidFormatException);
            }
        }
        if (this.custPart == null && !NEW_CUST_INSTANCE.toString().equals(this.cust.props.toString())) {
            try {
                object = PackagingURIHelper.createPartName("/docProps/custom.xml");
                this.pkg.addRelationship((PackagePartName)object, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
                this.custPart = this.pkg.createPart((PackagePartName)object, "application/vnd.openxmlformats-officedocument.custom-properties+xml");
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new POIXMLException(invalidFormatException);
            }
        }
        if (this.extPart != null) {
            object = new XmlOptions(POIXMLDocumentPart.DEFAULT_XML_OPTIONS);
            hashMap = new HashMap<String, String>();
            hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", "vt");
            object.setSaveSuggestedPrefixes(hashMap);
            outputStream = this.extPart.getOutputStream();
            if (this.extPart.getSize() > 0L) {
                this.extPart.clear();
            }
            this.ext.props.save(outputStream, object);
            outputStream.close();
        }
        if (this.custPart != null) {
            object = new XmlOptions(POIXMLDocumentPart.DEFAULT_XML_OPTIONS);
            hashMap = new HashMap();
            hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", "vt");
            object.setSaveSuggestedPrefixes(hashMap);
            outputStream = this.custPart.getOutputStream();
            this.cust.props.save(outputStream, object);
            outputStream.close();
        }
    }

    static {
        NEW_EXT_INSTANCE.addNewProperties();
        NEW_CUST_INSTANCE = PropertiesDocument.Factory.newInstance();
        NEW_CUST_INSTANCE.addNewProperties();
    }

    public static class CustomProperties {
        public static final String FORMAT_ID = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";
        private org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument props;

        private CustomProperties(org.openxmlformats.schemas.officeDocument.x2006.customProperties.PropertiesDocument propertiesDocument) {
            this.props = propertiesDocument;
        }

        public CTProperties getUnderlyingProperties() {
            return this.props.getProperties();
        }

        private CTProperty add(String string) {
            if (this.contains(string)) {
                throw new IllegalArgumentException("A property with this name already exists in the custom properties");
            }
            CTProperty cTProperty = this.props.getProperties().addNewProperty();
            int n = this.nextPid();
            cTProperty.setPid(n);
            cTProperty.setFmtid(FORMAT_ID);
            cTProperty.setName(string);
            return cTProperty;
        }

        public void addProperty(String string, String string2) {
            CTProperty cTProperty = this.add(string);
            cTProperty.setLpwstr(string2);
        }

        public void addProperty(String string, double d) {
            CTProperty cTProperty = this.add(string);
            cTProperty.setR8(d);
        }

        public void addProperty(String string, int n) {
            CTProperty cTProperty = this.add(string);
            cTProperty.setI4(n);
        }

        public void addProperty(String string, boolean bl) {
            CTProperty cTProperty = this.add(string);
            cTProperty.setBool(bl);
        }

        protected int nextPid() {
            int n = 1;
            for (CTProperty cTProperty : this.props.getProperties().getPropertyArray()) {
                if (cTProperty.getPid() <= n) continue;
                n = cTProperty.getPid();
            }
            return n + 1;
        }

        public boolean contains(String string) {
            for (CTProperty cTProperty : this.props.getProperties().getPropertyArray()) {
                if (!cTProperty.getName().equals(string)) continue;
                return true;
            }
            return false;
        }

        public CTProperty getProperty(String string) {
            for (CTProperty cTProperty : this.props.getProperties().getPropertyArray()) {
                if (!cTProperty.getName().equals(string)) continue;
                return cTProperty;
            }
            return null;
        }
    }

    public static class ExtendedProperties {
        private PropertiesDocument props;

        private ExtendedProperties(PropertiesDocument propertiesDocument) {
            this.props = propertiesDocument;
        }

        public org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties getUnderlyingProperties() {
            return this.props.getProperties();
        }

        public String getTemplate() {
            if (this.props.getProperties().isSetTemplate()) {
                return this.props.getProperties().getTemplate();
            }
            return null;
        }

        public String getManager() {
            if (this.props.getProperties().isSetManager()) {
                return this.props.getProperties().getManager();
            }
            return null;
        }

        public String getCompany() {
            if (this.props.getProperties().isSetCompany()) {
                return this.props.getProperties().getCompany();
            }
            return null;
        }

        public String getPresentationFormat() {
            if (this.props.getProperties().isSetPresentationFormat()) {
                return this.props.getProperties().getPresentationFormat();
            }
            return null;
        }

        public String getApplication() {
            if (this.props.getProperties().isSetApplication()) {
                return this.props.getProperties().getApplication();
            }
            return null;
        }

        public String getAppVersion() {
            if (this.props.getProperties().isSetAppVersion()) {
                return this.props.getProperties().getAppVersion();
            }
            return null;
        }

        public int getPages() {
            if (this.props.getProperties().isSetPages()) {
                return this.props.getProperties().getPages();
            }
            return -1;
        }

        public int getWords() {
            if (this.props.getProperties().isSetWords()) {
                return this.props.getProperties().getWords();
            }
            return -1;
        }

        public int getCharacters() {
            if (this.props.getProperties().isSetCharacters()) {
                return this.props.getProperties().getCharacters();
            }
            return -1;
        }

        public int getCharactersWithSpaces() {
            if (this.props.getProperties().isSetCharactersWithSpaces()) {
                return this.props.getProperties().getCharactersWithSpaces();
            }
            return -1;
        }

        public int getLines() {
            if (this.props.getProperties().isSetLines()) {
                return this.props.getProperties().getLines();
            }
            return -1;
        }

        public int getParagraphs() {
            if (this.props.getProperties().isSetParagraphs()) {
                return this.props.getProperties().getParagraphs();
            }
            return -1;
        }

        public int getSlides() {
            if (this.props.getProperties().isSetSlides()) {
                return this.props.getProperties().getSlides();
            }
            return -1;
        }

        public int getNotes() {
            if (this.props.getProperties().isSetNotes()) {
                return this.props.getProperties().getNotes();
            }
            return -1;
        }

        public int getTotalTime() {
            if (this.props.getProperties().isSetTotalTime()) {
                return this.props.getProperties().getTotalTime();
            }
            return -1;
        }

        public int getHiddenSlides() {
            if (this.props.getProperties().isSetHiddenSlides()) {
                return this.props.getProperties().getHiddenSlides();
            }
            return -1;
        }

        public int getMMClips() {
            if (this.props.getProperties().isSetMMClips()) {
                return this.props.getProperties().getMMClips();
            }
            return -1;
        }

        public String getHyperlinkBase() {
            if (this.props.getProperties().isSetHyperlinkBase()) {
                return this.props.getProperties().getHyperlinkBase();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoreProperties {
        private PackagePropertiesPart part;

        private CoreProperties(PackagePropertiesPart packagePropertiesPart) {
            this.part = packagePropertiesPart;
        }

        public String getCategory() {
            return this.part.getCategoryProperty().getValue();
        }

        public void setCategory(String string) {
            this.part.setCategoryProperty(string);
        }

        public String getContentStatus() {
            return this.part.getContentStatusProperty().getValue();
        }

        public void setContentStatus(String string) {
            this.part.setContentStatusProperty(string);
        }

        public String getContentType() {
            return this.part.getContentTypeProperty().getValue();
        }

        public void setContentType(String string) {
            this.part.setContentTypeProperty(string);
        }

        public Date getCreated() {
            return this.part.getCreatedProperty().getValue();
        }

        public void setCreated(Nullable<Date> nullable) {
            this.part.setCreatedProperty(nullable);
        }

        public void setCreated(String string) {
            this.part.setCreatedProperty(string);
        }

        public String getCreator() {
            return this.part.getCreatorProperty().getValue();
        }

        public void setCreator(String string) {
            this.part.setCreatorProperty(string);
        }

        public String getDescription() {
            return this.part.getDescriptionProperty().getValue();
        }

        public void setDescription(String string) {
            this.part.setDescriptionProperty(string);
        }

        public String getIdentifier() {
            return this.part.getIdentifierProperty().getValue();
        }

        public void setIdentifier(String string) {
            this.part.setIdentifierProperty(string);
        }

        public String getKeywords() {
            return this.part.getKeywordsProperty().getValue();
        }

        public void setKeywords(String string) {
            this.part.setKeywordsProperty(string);
        }

        public Date getLastPrinted() {
            return this.part.getLastPrintedProperty().getValue();
        }

        public void setLastPrinted(Nullable<Date> nullable) {
            this.part.setLastPrintedProperty(nullable);
        }

        public void setLastPrinted(String string) {
            this.part.setLastPrintedProperty(string);
        }

        public Date getModified() {
            return this.part.getModifiedProperty().getValue();
        }

        public void setModified(Nullable<Date> nullable) {
            this.part.setModifiedProperty(nullable);
        }

        public void setModified(String string) {
            this.part.setModifiedProperty(string);
        }

        public String getSubject() {
            return this.part.getSubjectProperty().getValue();
        }

        public void setSubjectProperty(String string) {
            this.part.setSubjectProperty(string);
        }

        public void setTitle(String string) {
            this.part.setTitleProperty(string);
        }

        public String getTitle() {
            return this.part.getTitleProperty().getValue();
        }

        public String getRevision() {
            return this.part.getRevisionProperty().getValue();
        }

        public void setRevision(String string) {
            try {
                Long.valueOf(string);
                this.part.setRevisionProperty(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public PackagePropertiesPart getUnderlyingProperties() {
            return this.part;
        }
    }
}

