/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLFactory;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.exceptions.PartAlreadyExistsException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POIXMLDocumentPart {
    private static final POILogger logger = POILogFactory.getLogger(POIXMLDocumentPart.class);
    public static final XmlOptions DEFAULT_XML_OPTIONS = new XmlOptions();
    private String coreDocumentRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    private PackagePart packagePart;
    private PackageRelationship packageRel;
    private POIXMLDocumentPart parent;
    private Map<String, POIXMLDocumentPart> relations = new LinkedHashMap<String, POIXMLDocumentPart>();
    private int relationCounter = 0;

    int incrementRelationCounter() {
        ++this.relationCounter;
        return this.relationCounter;
    }

    int decrementRelationCounter() {
        --this.relationCounter;
        return this.relationCounter;
    }

    int getRelationCounter() {
        return this.relationCounter;
    }

    public POIXMLDocumentPart(OPCPackage oPCPackage) {
        this(oPCPackage, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
    }

    public POIXMLDocumentPart(OPCPackage oPCPackage, String string) {
        this.coreDocumentRel = string;
        PackageRelationship packageRelationship = oPCPackage.getRelationshipsByType(this.coreDocumentRel).getRelationship(0);
        if (packageRelationship == null && (packageRelationship = oPCPackage.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument").getRelationship(0)) != null) {
            throw new POIXMLException("Strict OOXML isn't currently supported, please see bug #57699");
        }
        if (packageRelationship == null) {
            throw new POIXMLException("OOXML file structure broken/invalid - no core document found!");
        }
        this.packagePart = oPCPackage.getPart(packageRelationship);
        this.packageRel = packageRelationship;
    }

    public POIXMLDocumentPart() {
    }

    public POIXMLDocumentPart(PackagePart packagePart, PackageRelationship packageRelationship) {
        this.packagePart = packagePart;
        this.packageRel = packageRelationship;
    }

    public POIXMLDocumentPart(POIXMLDocumentPart pOIXMLDocumentPart, PackagePart packagePart, PackageRelationship packageRelationship) {
        this.packagePart = packagePart;
        this.packageRel = packageRelationship;
        this.parent = pOIXMLDocumentPart;
    }

    protected final void rebase(OPCPackage oPCPackage) throws InvalidFormatException {
        PackageRelationshipCollection packageRelationshipCollection = this.packagePart.getRelationshipsByType(this.coreDocumentRel);
        if (packageRelationshipCollection.size() != 1) {
            throw new IllegalStateException("Tried to rebase using " + this.coreDocumentRel + " but found " + packageRelationshipCollection.size() + " parts of the right type");
        }
        this.packageRel = packageRelationshipCollection.getRelationship(0);
        this.packagePart = this.packagePart.getRelatedPart(this.packageRel);
    }

    public final PackagePart getPackagePart() {
        return this.packagePart;
    }

    public final PackageRelationship getPackageRelationship() {
        return this.packageRel;
    }

    public final List<POIXMLDocumentPart> getRelations() {
        return Collections.unmodifiableList(new ArrayList<POIXMLDocumentPart>(this.relations.values()));
    }

    public final POIXMLDocumentPart getRelationById(String string) {
        return this.relations.get(string);
    }

    public final String getRelationId(POIXMLDocumentPart pOIXMLDocumentPart) {
        for (Map.Entry<String, POIXMLDocumentPart> entry : this.relations.entrySet()) {
            if (entry.getValue() != pOIXMLDocumentPart) continue;
            return entry.getKey();
        }
        return null;
    }

    public final void addRelation(String string, POIXMLDocumentPart pOIXMLDocumentPart) {
        this.relations.put(string, pOIXMLDocumentPart);
        pOIXMLDocumentPart.incrementRelationCounter();
    }

    protected final void removeRelation(POIXMLDocumentPart pOIXMLDocumentPart) {
        this.removeRelation(pOIXMLDocumentPart, true);
    }

    protected final boolean removeRelation(POIXMLDocumentPart pOIXMLDocumentPart, boolean bl) {
        String string = this.getRelationId(pOIXMLDocumentPart);
        if (string == null) {
            return false;
        }
        pOIXMLDocumentPart.decrementRelationCounter();
        this.getPackagePart().removeRelationship(string);
        this.relations.remove(string);
        if (bl && pOIXMLDocumentPart.getRelationCounter() == 0) {
            try {
                pOIXMLDocumentPart.onDocumentRemove();
            }
            catch (IOException iOException) {
                throw new POIXMLException(iOException);
            }
            this.getPackagePart().getPackage().removePart(pOIXMLDocumentPart.getPackagePart());
        }
        return true;
    }

    public final POIXMLDocumentPart getParent() {
        return this.parent;
    }

    public String toString() {
        return this.packagePart == null ? "" : this.packagePart.toString();
    }

    protected void commit() throws IOException {
    }

    protected final void onSave(Set<PackagePart> set) throws IOException {
        this.prepareForCommit();
        this.commit();
        set.add(this.getPackagePart());
        for (POIXMLDocumentPart pOIXMLDocumentPart : this.relations.values()) {
            if (set.contains(pOIXMLDocumentPart.getPackagePart())) continue;
            pOIXMLDocumentPart.onSave(set);
        }
    }

    protected void prepareForCommit() {
        PackagePart packagePart = this.getPackagePart();
        if (packagePart != null) {
            packagePart.clear();
        }
    }

    public final POIXMLDocumentPart createRelationship(POIXMLRelation pOIXMLRelation, POIXMLFactory pOIXMLFactory) {
        return this.createRelationship(pOIXMLRelation, pOIXMLFactory, -1, false);
    }

    public final POIXMLDocumentPart createRelationship(POIXMLRelation pOIXMLRelation, POIXMLFactory pOIXMLFactory, int n) {
        return this.createRelationship(pOIXMLRelation, pOIXMLFactory, n, false);
    }

    protected final POIXMLDocumentPart createRelationship(POIXMLRelation pOIXMLRelation, POIXMLFactory pOIXMLFactory, int n, boolean bl) {
        try {
            PackagePartName packagePartName = PackagingURIHelper.createPartName(pOIXMLRelation.getFileName(n));
            PackageRelationship packageRelationship = null;
            PackagePart packagePart = this.packagePart.getPackage().createPart(packagePartName, pOIXMLRelation.getContentType());
            if (!bl) {
                packageRelationship = this.packagePart.addRelationship(packagePartName, TargetMode.INTERNAL, pOIXMLRelation.getRelation());
            }
            POIXMLDocumentPart pOIXMLDocumentPart = pOIXMLFactory.newDocumentPart(pOIXMLRelation);
            pOIXMLDocumentPart.packageRel = packageRelationship;
            pOIXMLDocumentPart.packagePart = packagePart;
            pOIXMLDocumentPart.parent = this;
            if (!bl) {
                this.addRelation(packageRelationship.getId(), pOIXMLDocumentPart);
            }
            return pOIXMLDocumentPart;
        }
        catch (PartAlreadyExistsException partAlreadyExistsException) {
            throw partAlreadyExistsException;
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    protected void read(POIXMLFactory pOIXMLFactory, Map<PackagePart, POIXMLDocumentPart> map) throws OpenXML4JException {
        PackageRelationshipCollection packageRelationshipCollection = this.packagePart.getRelationships();
        for (PackageRelationship packageRelationship : packageRelationshipCollection) {
            Object object;
            PackagePart packagePart;
            if (packageRelationship.getTargetMode() != TargetMode.INTERNAL) continue;
            URI uRI = packageRelationship.getTargetURI();
            if (uRI.getRawFragment() != null) {
                packagePart = null;
            } else {
                object = PackagingURIHelper.createPartName(uRI);
                packagePart = this.packagePart.getPackage().getPart((PackagePartName)object);
                if (packagePart == null) {
                    logger.log(7, new Object[]{"Skipped invalid entry " + packageRelationship.getTargetURI()});
                    continue;
                }
            }
            if (!map.containsKey(packagePart)) {
                object = pOIXMLFactory.createDocumentPart(this, packageRelationship, packagePart);
                ((POIXMLDocumentPart)object).parent = this;
                this.addRelation(packageRelationship.getId(), (POIXMLDocumentPart)object);
                if (packagePart == null) continue;
                map.put(packagePart, (POIXMLDocumentPart)object);
                if (!packagePart.hasRelationships()) continue;
                ((POIXMLDocumentPart)object).read(pOIXMLFactory, map);
                continue;
            }
            this.addRelation(packageRelationship.getId(), map.get(packagePart));
        }
    }

    protected PackagePart getTargetPart(PackageRelationship packageRelationship) throws InvalidFormatException {
        return this.getPackagePart().getRelatedPart(packageRelationship);
    }

    protected void onDocumentCreate() throws IOException {
    }

    protected void onDocumentRead() throws IOException {
    }

    protected void onDocumentRemove() throws IOException {
    }

    static {
        DEFAULT_XML_OPTIONS.setSaveOuter();
        DEFAULT_XML_OPTIONS.setUseDefaultNamespace();
        DEFAULT_XML_OPTIONS.setSaveAggressiveNamespaces();
        DEFAULT_XML_OPTIONS.setCharacterEncoding("UTF-8");
    }
}

