/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLFactory;
import ai2.org.apache.poi.POIXMLProperties;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.poifs.common.POIFSConstants;
import ai2.org.apache.poi.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.xmlbeans.impl.common.SystemCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class POIXMLDocument
extends POIXMLDocumentPart
implements Closeable {
    public static final String DOCUMENT_CREATOR = "Apache POI";
    public static final String OLE_OBJECT_REL_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    public static final String PACK_OBJECT_REL_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    private OPCPackage pkg;
    private POIXMLProperties properties;

    protected POIXMLDocument(OPCPackage oPCPackage) {
        super(oPCPackage);
        this.init(oPCPackage);
    }

    protected POIXMLDocument(OPCPackage oPCPackage, String string) {
        super(oPCPackage, string);
        this.init(oPCPackage);
    }

    private void init(OPCPackage oPCPackage) {
        this.pkg = oPCPackage;
        SystemCache.get().setSaxLoader(null);
    }

    public static OPCPackage openPackage(String string) throws IOException {
        try {
            return OPCPackage.open(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IOException(invalidFormatException.toString());
        }
    }

    public OPCPackage getPackage() {
        return this.pkg;
    }

    protected PackagePart getCorePart() {
        return this.getPackagePart();
    }

    protected PackagePart[] getRelatedByType(String string) throws InvalidFormatException {
        PackageRelationshipCollection packageRelationshipCollection = this.getPackagePart().getRelationshipsByType(string);
        PackagePart[] packagePartArray = new PackagePart[packageRelationshipCollection.size()];
        int n = 0;
        for (PackageRelationship packageRelationship : packageRelationshipCollection) {
            packagePartArray[n] = this.getPackagePart().getRelatedPart(packageRelationship);
            ++n;
        }
        return packagePartArray;
    }

    public static boolean hasOOXMLHeader(InputStream inputStream) throws IOException {
        inputStream.mark(4);
        byte[] byArray = new byte[4];
        int n = IOUtils.readFully(inputStream, byArray);
        if (inputStream instanceof PushbackInputStream) {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
            pushbackInputStream.unread(byArray, 0, n);
        } else {
            inputStream.reset();
        }
        return n == 4 && byArray[0] == POIFSConstants.OOXML_FILE_HEADER[0] && byArray[1] == POIFSConstants.OOXML_FILE_HEADER[1] && byArray[2] == POIFSConstants.OOXML_FILE_HEADER[2] && byArray[3] == POIFSConstants.OOXML_FILE_HEADER[3];
    }

    public POIXMLProperties getProperties() {
        if (this.properties == null) {
            try {
                this.properties = new POIXMLProperties(this.pkg);
            }
            catch (Exception exception) {
                throw new POIXMLException(exception);
            }
        }
        return this.properties;
    }

    public abstract List<PackagePart> getAllEmbedds() throws OpenXML4JException;

    protected final void load(POIXMLFactory pOIXMLFactory) throws IOException {
        HashMap<PackagePart, POIXMLDocumentPart> hashMap = new HashMap<PackagePart, POIXMLDocumentPart>();
        try {
            this.read(pOIXMLFactory, hashMap);
        }
        catch (OpenXML4JException openXML4JException) {
            throw new POIXMLException(openXML4JException);
        }
        this.onDocumentRead();
        hashMap.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.pkg != null) {
            if (this.pkg.getPackageAccess() == PackageAccess.READ) {
                this.pkg.revert();
            } else {
                this.pkg.close();
            }
            this.pkg = null;
        }
    }

    public final void write(OutputStream outputStream) throws IOException {
        HashSet<PackagePart> hashSet = new HashSet<PackagePart>();
        this.onSave(hashSet);
        hashSet.clear();
        this.getProperties().commit();
        this.getPackage().save(outputStream);
    }
}

