/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.manager;

import com.activeintra.manager.AIFunction;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParam {
    List<Integer> searchIndexs = new ArrayList<Integer>();
    List<Integer> searchTypes = new ArrayList<Integer>();
    List<List<String>> searchTexts = new ArrayList<List<String>>();
    int startIndex = -1;
    int endIndex = -1;
    boolean useExclude = false;

    public HeaderParam() {
    }

    public HeaderParam(int n2) {
        this.put(n2);
    }

    public HeaderParam(int n2, String string) {
        this.put(n2, string);
    }

    public HeaderParam(int n2, String string, boolean bl) {
        this.put(n2, string);
        this.useExclude = bl;
    }

    public void put(int n2) {
        this.searchIndexs.add(n2);
        this.searchTypes.add(0);
        if (this.startIndex == -1 || this.startIndex > n2) {
            this.startIndex = n2;
        }
        if (this.endIndex == -1 || this.endIndex < n2 + 1) {
            this.endIndex = n2 + 1;
        }
        this.searchTexts.add(null);
    }

    public void put(int n2, String string) {
        this.searchIndexs.add(n2);
        this.searchTypes.add(0);
        if (this.startIndex == -1 || this.startIndex > n2) {
            this.startIndex = n2;
        }
        if (this.endIndex == -1 || this.endIndex < n2 + 1) {
            this.endIndex = n2 + 1;
        }
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            AIFunction.tokenizer(string, 0, string.length(), arrayList, "|", "", "", "", "\\", false);
            this.searchTexts.add(arrayList);
            return;
        }
        this.searchTexts.add(null);
    }

    public void put(int n2, List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.searchIndexs.add(n2);
        this.searchTypes.add(1);
        if (this.startIndex == -1 || this.startIndex > n2) {
            this.startIndex = n2;
        }
        if (this.endIndex == -1 || this.endIndex < n2 + list.size()) {
            this.endIndex = n2 + list.size();
        }
        this.searchTexts.add(new ArrayList<String>(list));
    }

    public void setExclude(boolean bl) {
        this.useExclude = bl;
    }

    public void clear() {
        this.searchIndexs.clear();
        this.searchTypes.clear();
        this.searchTexts.clear();
        this.startIndex = -1;
        this.endIndex = -1;
        this.useExclude = false;
    }

    int getStartIndex() {
        return this.startIndex;
    }

    int getEndIndex() {
        return this.endIndex;
    }

    boolean search(List<String> list, int[] nArray) {
        int n2 = this.searchIndexs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            int n3 = this.searchIndexs.get(i2);
            int n4 = this.searchTypes.get(i2);
            List<String> list2 = this.searchTexts.get(i2);
            if (n4 == 0) {
                if (list2 != null && list2.indexOf(list.get(n3 - this.startIndex)) == -1) continue;
                nArray[0] = n3 + 1;
                return !this.useExclude;
            }
            n4 = list2.size();
            for (int i3 = 0; i3 < n4 && ((string = list2.get(i3)) == null || string.equals(list.get(i3 + n3 - this.startIndex))); ++i3) {
                if (i3 != n4 - 1) continue;
                nArray[0] = n3 + n4;
                return !this.useExclude;
            }
        }
        nArray[0] = this.endIndex;
        return this.useExclude;
    }
}

