/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.manager;

import com.activeintra.manager.AIFunction;
import com.activeintra.manager.k;
import com.activeintra.manager.m;
import com.activeintra.manager.q;
import com.activeintra.manager.r;
import com.activeintra.util.AIReportNexacro;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class AIReportContextListener
implements ServletContextListener {
    private volatile ServletContext context;
    private volatile Timer timer;
    private volatile Properties props;
    private Logger logger = Logger.getLogger((String)"AIReportContextListener");

    public void contextInitialized(ServletContextEvent object) {
        Object object2;
        this.context = object.getServletContext();
        object = this.findResourceStream("/WEB-INF/", "AIReport.properties", this.context);
        if (object != null) {
            this.props = new Properties();
            try {
                this.props.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                this.errorLogging("#1010 AIReport.properties load failed; " + iOException.getMessage());
                this.props = null;
            }
        }
        if (this.props != null) {
            String string;
            object = this.props.getProperty("defaultURIEncoding");
            if (object != null && !((String)(object = ((String)object).toUpperCase())).equals("UTF-8")) {
                this.context.setAttribute("ai.defaultURIEncoding", object);
            }
            if ((string = this.props.getProperty("parameterDecoder.useRequest")) != null) {
                this.context.setAttribute("ai.parameterDecoder.useRequest", (Object)string);
            }
        }
        if (this.props != null && (object = this.props.getProperty("fontPath")) != null) {
            object = ((String)object).startsWith("///") ? ((String)object).substring(2) : "file:" + (String)object;
            boolean bl = false;
            try {
                Class.forName("com.google.typography.font.sfntly.FontFactory");
                bl = true;
            }
            catch (Throwable throwable) {
                this.logger.info((Object)"Libray <sfntly-1.x.jar> not found");
            }
            if (bl) {
                k.a((String)object, this.context, this.logger);
            } else {
                m.a((String)object, this.context, this.logger);
            }
        }
        this.debugLogging("#0001 file delete listener Start...................");
        int n2 = 3;
        int n3 = 45;
        if (this.props != null && (object2 = this.props.getProperty("TemporaryFileDeleteListenerTime")) != null) {
            n2 = AIFunction.atoi(((String)object2).split(",")[0]);
            n3 = AIFunction.atoi(((String)object2).split(",")[1]);
            if (n2 > 24) {
                n2 = 0;
            }
            if (n3 > 59) {
                n3 = 0;
            }
        }
        object2 = Calendar.getInstance();
        ((Calendar)object2).set(11, n2);
        ((Calendar)object2).set(12, n3);
        ((Calendar)object2).set(13, 0);
        Date date = new Date(((Calendar)object2).getTimeInMillis());
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new q(this), date, 86400000L);
        if (this.props != null) {
            this.prepareNexacroInterface();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void clearPdfDir() {
        if (this.props == null) {
            return;
        }
        String object = this.props.getProperty("pdfPath");
        if (object == null) {
            return;
        }
        File file = new File(object);
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        long l2 = System.currentTimeMillis() - 86400000L;
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file2 = fileArray2[i2];
            if (file2.isDirectory() || file2.lastModified() >= l2) continue;
            file2.delete();
        }
    }

    private void callTemporaryFileDelete() {
        if (this.props == null) {
            return;
        }
        this.debugLogging("#0002 file delete listener wakeup..............");
        String string = this.props.getProperty("pdfPath");
        if (string == null) {
            return;
        }
        this.temporaryFileDelete(string);
        string = this.props.getProperty("imagePath");
        if (string == null) {
            return;
        }
        this.temporaryFileDelete(string);
        this.debugLogging("#0003 file delete listener sleep..............");
    }

    private void temporaryFileDelete(String string) {
        Object object;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string2 = simpleDateFormat.format(calendar.getTime());
        Object object2 = new File(string);
        int n2 = 0;
        if (((File)object2).isDirectory()) {
            object2 = ((File)object2).listFiles();
            object = object2;
            int n3 = ((File[])object2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                boolean bl;
                String string3;
                File file = object[i2];
                if (file.isDirectory() || !((string3 = file.toString()).endsWith(".prop") | string3.endsWith(".pdf") | string3.endsWith(".xls") | string3.endsWith(".hwp") | string3.endsWith(".png") | string3.endsWith(".jpg") | string3.endsWith(".gul") | string3.endsWith(".txt") | string3.endsWith(".doc") | string3.endsWith(".ppt") | string3.endsWith(".xlsx") | string3.endsWith(".json") | string3.endsWith(".pgs")) || string2.compareTo(string3 = simpleDateFormat.format(file.lastModified())) <= 0 || !(bl = file.delete())) continue;
                ++n2;
            }
        }
        object2 = new SimpleDateFormat("yyyy:MM:dd hh:mm:ss");
        ((DateFormat)object2).getTimeZone();
        object = TimeZone.getTimeZone("GMT+9");
        ((DateFormat)object2).setTimeZone((TimeZone)object);
        string2 = ((DateFormat)object2).format(calendar.getTime());
        this.debugLogging("#1100 delete path=" + string);
        this.debugLogging("#1200 delete time = " + string2 + " delete count=" + n2);
    }

    private InputStream findResourceStream(String iterator, String string, ServletContext servletContext) {
        String string2;
        if ((iterator = servletContext.getResourcePaths((String)((Object)iterator))) == null) {
            return null;
        }
        Object object = new ArrayList<String>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (string2.endsWith(string)) {
                return servletContext.getResourceAsStream(string2);
            }
            if (string2.charAt(string2.length() - 1) != '/') continue;
            object.add(string2);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            object = this.findResourceStream(string2, string, servletContext);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private void prepareNexacroInterface() {
        Object object = this.props.getProperty("nexacroScheduleTimeZone");
        if (object == null) {
            return;
        }
        try {
            Class.forName("com.nexacro.xapi.data.DataSet");
        }
        catch (Throwable throwable) {
            return;
        }
        Object object2 = this.context.getRealPath("/WEB-INF/AIReportNexacro");
        if (object2 == null) {
            object2 = (File)this.context.getAttribute("javax.servlet.context.tempdir");
            object2 = new File((File)object2, "AIReportNexacro");
        } else {
            object2 = new File((String)object2);
        }
        if (((File)object2).exists() ? !((File)object2).isDirectory() : !((File)object2).mkdirs()) {
            return;
        }
        try {
            File.createTempFile("test", ".tmp", (File)object2).delete();
        }
        catch (IOException iOException) {
            return;
        }
        AIReportNexacro.saveBaseDir = object2;
        object = Calendar.getInstance(TimeZone.getTimeZone((String)object));
        object2 = new int[]{7, 12, 16, 21};
        for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
            ((Calendar)object).set(11, (int)object2[i2]);
            ((Calendar)object).set(12, 20);
            ((Calendar)object).set(13, 0);
            Date date = new Date(((Calendar)object).getTimeInMillis());
            this.timer.scheduleAtFixedRate((TimerTask)new r(this), date, 86400000L);
        }
    }

    private void errorLogging(Object object) {
        this.logger.error(object);
    }

    private void debugLogging(Object object) {
        this.logger.info(object);
    }

    static /* synthetic */ void access$000(AIReportContextListener aIReportContextListener) {
        aIReportContextListener.callTemporaryFileDelete();
    }

    static /* synthetic */ ServletContext access$100(AIReportContextListener aIReportContextListener) {
        return aIReportContextListener.context;
    }

    static /* synthetic */ void access$200(AIReportContextListener aIReportContextListener, Object object) {
        aIReportContextListener.errorLogging(object);
    }
}

