/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.xalan;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.BarcodeUtil;
import ai.org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import ai.org.krysalis.barcode4j.tools.ConfigurationUtil;
import ai.org.krysalis.barcode4j.xalan.ElemWrappingConfiguration;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BarcodeExt {
    public DocumentFragment generate(NodeList nodeList, String string) throws SAXException {
        try {
            Configuration configuration = ConfigurationUtil.buildConfiguration(nodeList.item(0));
            BarcodeGenerator barcodeGenerator = BarcodeUtil.getInstance().createBarcodeGenerator(configuration);
            int n = configuration.getAttributeAsInteger("orientation", 0);
            n = BarcodeDimension.normalizeOrientation(n);
            SVGCanvasProvider sVGCanvasProvider = configuration.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(configuration.getAttribute("prefix", "svg"), n) : new SVGCanvasProvider(false, n);
            barcodeGenerator.generateBarcode(sVGCanvasProvider, string);
            return sVGCanvasProvider.getDOMFragment();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    public DocumentFragment barcode(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        try {
            ElemWrappingConfiguration elemWrappingConfiguration = new ElemWrappingConfiguration((Element)elemExtensionCall);
            String string = ConfigurationUtil.getMessage((Configuration)elemWrappingConfiguration);
            BarcodeGenerator barcodeGenerator = BarcodeUtil.getInstance().createBarcodeGenerator((Configuration)elemWrappingConfiguration);
            int n = elemWrappingConfiguration.getAttributeAsInteger("orientation", 0);
            n = BarcodeDimension.normalizeOrientation(n);
            SVGCanvasProvider sVGCanvasProvider = elemWrappingConfiguration.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(elemWrappingConfiguration.getAttribute("prefix", "svg"), n) : new SVGCanvasProvider(false, n);
            barcodeGenerator.generateBarcode(sVGCanvasProvider, string);
            return sVGCanvasProvider.getDOMFragment();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TransformerException(exception);
        }
    }
}

