/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.tools;

import ai.org.krysalis.barcode4j.tools.MessageUtil;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ConfigurationUtil {
    protected ConfigurationUtil() {
        throw new UnsupportedOperationException();
    }

    public static Configuration buildConfiguration(Node node) {
        return ConfigurationUtil.processNode(node);
    }

    private static Element findDocumentElement(Document document) {
        try {
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            Node node = null;
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                node = document.getChildNodes().item(i);
                if (node.getNodeType() != 1) continue;
                return (Element)node;
            }
            return null;
        }
    }

    private static DefaultConfiguration processNode(Node node) {
        if (node.getNodeType() == 1) {
            return ConfigurationUtil.processElement((Element)node);
        }
        if (node.getNodeType() == 9) {
            return ConfigurationUtil.processElement(ConfigurationUtil.findDocumentElement((Document)node));
        }
        if (node.getNodeType() == 11) {
            DocumentFragment documentFragment = (DocumentFragment)node;
            return ConfigurationUtil.processNode(documentFragment.getFirstChild());
        }
        return null;
    }

    private static DefaultConfiguration processElement(Element element) {
        Node node;
        int n;
        String string = element.getLocalName();
        if (string == null) {
            string = element.getTagName();
        }
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration(string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            node = (Attr)namedNodeMap.item(n);
            defaultConfiguration.setAttribute(node.getName(), node.getValue());
        }
        for (n = 0; n < element.getChildNodes().getLength(); ++n) {
            Object object;
            node = element.getChildNodes().item(n);
            if (node.getNodeType() == 2) {
                object = (Attr)node;
                defaultConfiguration.setAttribute(object.getName(), object.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 1) {
                defaultConfiguration.addChild((Configuration)ConfigurationUtil.processElement((Element)node));
                continue;
            }
            if (node.getNodeType() != 3) continue;
            object = defaultConfiguration.getValue("") + ((Text)node).getData();
            defaultConfiguration.setValue(((String)object).trim());
        }
        return defaultConfiguration;
    }

    public static String getMessage(Configuration configuration) throws ConfigurationException {
        String string;
        try {
            string = configuration.getAttribute("message");
        }
        catch (ConfigurationException configurationException) {
            try {
                string = configuration.getAttribute("msg");
            }
            catch (ConfigurationException configurationException2) {
                throw configurationException;
            }
        }
        string = MessageUtil.unescapeUnicode(string);
        return string;
    }
}

