/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.servlet;

import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.BarcodeUtil;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import ai.org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import ai.org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import ai.org.krysalis.barcode4j.tools.MimeTypes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.w3c.dom.DocumentFragment;

public class BarcodeServlet
extends HttpServlet {
    private static final long serialVersionUID = -1612710758060435089L;
    public static final String BARCODE_MSG = "msg";
    public static final String BARCODE_TYPE = "type";
    public static final String BARCODE_HEIGHT = "height";
    public static final String BARCODE_MODULE_WIDTH = "mw";
    public static final String BARCODE_WIDE_FACTOR = "wf";
    public static final String BARCODE_QUIET_ZONE = "qz";
    public static final String BARCODE_HUMAN_READABLE_POS = "hrp";
    public static final String BARCODE_FORMAT = "fmt";
    public static final String BARCODE_IMAGE_RESOLUTION = "res";
    public static final String BARCODE_IMAGE_GRAYSCALE = "gray";
    public static final String BARCODE_HUMAN_READABLE_SIZE = "hrsize";
    public static final String BARCODE_HUMAN_READABLE_FONT = "hrfont";
    public static final String BARCODE_HUMAN_READABLE_PATTERN = "hrpattern";
    private transient Logger log = new ConsoleLogger(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String string = this.determineFormat(httpServletRequest);
            int n = 0;
            Configuration configuration = this.buildCfg(httpServletRequest);
            String string2 = httpServletRequest.getParameter(BARCODE_MSG);
            if (string2 == null) {
                string2 = "0123456789";
            }
            BarcodeUtil barcodeUtil = BarcodeUtil.getInstance();
            BarcodeGenerator barcodeGenerator = barcodeUtil.createBarcodeGenerator(configuration);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            try {
                if (string.equals("image/svg+xml")) {
                    SVGCanvasProvider sVGCanvasProvider = new SVGCanvasProvider(false, n);
                    barcodeGenerator.generateBarcode(sVGCanvasProvider, string2);
                    DocumentFragment documentFragment = sVGCanvasProvider.getDOMFragment();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(documentFragment);
                    StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                    transformer.transform(dOMSource, streamResult);
                } else if (string.equals("image/x-eps")) {
                    EPSCanvasProvider ePSCanvasProvider = new EPSCanvasProvider(byteArrayOutputStream, n);
                    barcodeGenerator.generateBarcode(ePSCanvasProvider, string2);
                    ePSCanvasProvider.finish();
                } else {
                    String string3 = httpServletRequest.getParameter(BARCODE_IMAGE_RESOLUTION);
                    int n2 = 300;
                    if (string3 != null) {
                        n2 = Integer.parseInt(string3);
                    }
                    if (n2 > 2400) {
                        throw new IllegalArgumentException("Resolutions above 2400dpi are not allowed");
                    }
                    if (n2 < 10) {
                        throw new IllegalArgumentException("Minimum resolution must be 10dpi");
                    }
                    String string4 = httpServletRequest.getParameter(BARCODE_IMAGE_GRAYSCALE);
                    BitmapCanvasProvider bitmapCanvasProvider = "true".equalsIgnoreCase(string4) ? new BitmapCanvasProvider(byteArrayOutputStream, string, n2, 10, true, n) : new BitmapCanvasProvider(byteArrayOutputStream, string, n2, 12, false, n);
                    barcodeGenerator.generateBarcode(bitmapCanvasProvider, string2);
                    bitmapCanvasProvider.finish();
                }
            }
            finally {
                byteArrayOutputStream.close();
            }
            httpServletResponse.setContentType(string);
            httpServletResponse.setContentLength(byteArrayOutputStream.size());
            httpServletResponse.getOutputStream().write(byteArrayOutputStream.toByteArray());
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            this.log.error("Error while generating barcode", (Throwable)exception);
            throw new ServletException((Throwable)exception);
        }
        catch (Throwable throwable) {
            this.log.error("Error while generating barcode", throwable);
            throw new ServletException(throwable);
        }
    }

    protected String determineFormat(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(BARCODE_FORMAT);
        if ((string = MimeTypes.expandFormat(string)) == null) {
            string = "image/svg+xml";
        }
        return string;
    }

    protected Configuration buildCfg(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        String string3;
        DefaultConfiguration defaultConfiguration;
        DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration("barcode");
        String string4 = httpServletRequest.getParameter(BARCODE_TYPE);
        if (string4 == null) {
            string4 = "code128";
        }
        DefaultConfiguration defaultConfiguration3 = new DefaultConfiguration(string4);
        defaultConfiguration2.addChild((Configuration)defaultConfiguration3);
        String string5 = httpServletRequest.getParameter(BARCODE_HEIGHT);
        if (string5 != null) {
            defaultConfiguration = new DefaultConfiguration(BARCODE_HEIGHT);
            defaultConfiguration.setValue(string5);
            defaultConfiguration3.addChild((Configuration)defaultConfiguration);
        }
        if ((string3 = httpServletRequest.getParameter(BARCODE_MODULE_WIDTH)) != null) {
            defaultConfiguration = new DefaultConfiguration("module-width");
            defaultConfiguration.setValue(string3);
            defaultConfiguration3.addChild((Configuration)defaultConfiguration);
        }
        if ((string2 = httpServletRequest.getParameter(BARCODE_WIDE_FACTOR)) != null) {
            defaultConfiguration = new DefaultConfiguration("wide-factor");
            defaultConfiguration.setValue(string2);
            defaultConfiguration3.addChild((Configuration)defaultConfiguration);
        }
        if ((string = httpServletRequest.getParameter(BARCODE_QUIET_ZONE)) != null) {
            defaultConfiguration = new DefaultConfiguration("quiet-zone");
            if (string.startsWith("disable")) {
                defaultConfiguration.setAttribute("enabled", "false");
            } else {
                defaultConfiguration.setValue(string);
            }
            defaultConfiguration3.addChild((Configuration)defaultConfiguration);
        }
        String string6 = httpServletRequest.getParameter(BARCODE_HUMAN_READABLE_POS);
        String string7 = httpServletRequest.getParameter(BARCODE_HUMAN_READABLE_PATTERN);
        String string8 = httpServletRequest.getParameter(BARCODE_HUMAN_READABLE_SIZE);
        String string9 = httpServletRequest.getParameter(BARCODE_HUMAN_READABLE_FONT);
        if (string6 != null || string7 != null || string8 != null || string9 != null) {
            DefaultConfiguration defaultConfiguration4;
            defaultConfiguration = new DefaultConfiguration("human-readable");
            if (string7 != null) {
                defaultConfiguration4 = new DefaultConfiguration("pattern");
                defaultConfiguration4.setValue(string7);
                defaultConfiguration.addChild((Configuration)defaultConfiguration4);
            }
            if (string8 != null) {
                defaultConfiguration4 = new DefaultConfiguration("font-size");
                defaultConfiguration4.setValue(string8);
                defaultConfiguration.addChild((Configuration)defaultConfiguration4);
            }
            if (string9 != null) {
                defaultConfiguration4 = new DefaultConfiguration("font-name");
                defaultConfiguration4.setValue(string9);
                defaultConfiguration.addChild((Configuration)defaultConfiguration4);
            }
            if (string6 != null) {
                defaultConfiguration4 = new DefaultConfiguration("placement");
                defaultConfiguration4.setValue(string6);
                defaultConfiguration.addChild((Configuration)defaultConfiguration4);
            }
            defaultConfiguration3.addChild((Configuration)defaultConfiguration);
        }
        return defaultConfiguration2;
    }
}

