/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.java2d;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.output.AbstractCanvasProvider;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Java2DCanvasProvider
extends AbstractCanvasProvider {
    private static final boolean DEBUG = false;
    private Graphics2D g2d;

    public Java2DCanvasProvider(Graphics2D graphics2D, int n) {
        super(n);
        this.setGraphics2D(graphics2D);
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.g2d = graphics2D;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public void establishDimensions(BarcodeDimension barcodeDimension) {
        super.establishDimensions(barcodeDimension);
        int n = BarcodeDimension.normalizeOrientation(this.getOrientation());
        double d = barcodeDimension.getWidthPlusQuiet(n);
        double d2 = barcodeDimension.getHeightPlusQuiet(n);
        this.g2d = (Graphics2D)this.g2d.create();
        switch (n) {
            case 90: {
                this.g2d.rotate(-1.5707963267948966);
                this.g2d.translate(-d2, 0.0);
                break;
            }
            case 180: {
                this.g2d.rotate(-Math.PI);
                this.g2d.translate(-d, -d2);
                break;
            }
            case 270: {
                this.g2d.rotate(-4.71238898038469);
                this.g2d.translate(0.0, -d);
                break;
            }
        }
    }

    public void deviceFillRect(double d, double d2, double d3, double d4) {
        this.g2d.fill(new Rectangle2D.Double(d, d2, d3, d4));
    }

    public void deviceDrawRect(double d, double d2, double d3, double d4) {
        this.g2d.draw(new Rectangle2D.Double(d, d2, d3, d4));
    }

    public void deviceText(String string, double d, double d2, double d3, String string2, double d4, TextAlignment textAlignment) {
        Font font = new Font(string2, 0, (int)Math.round(d4));
        FontRenderContext fontRenderContext = this.g2d.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        float f = (float)glyphVector.getLogicalBounds().getWidth();
        float f2 = (float)(d2 - d - (double)f);
        float f3 = glyphVector.getNumGlyphs() > 1 ? f2 / (float)(glyphVector.getNumGlyphs() - 1) : 0.0f;
        float f4 = textAlignment == TextAlignment.TA_JUSTIFY ? (string.length() > 1 ? 0.0f : f2 / 2.0f) : (textAlignment == TextAlignment.TA_CENTER ? f2 / 2.0f : (textAlignment == TextAlignment.TA_RIGHT ? f2 : 0.0f));
        Font font2 = this.g2d.getFont();
        this.g2d.setFont(font);
        if (textAlignment == TextAlignment.TA_JUSTIFY) {
            for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
                Point2D point2D = glyphVector.getGlyphPosition(i);
                point2D.setLocation(point2D.getX() + (double)((float)i * f3), point2D.getY());
                glyphVector.setGlyphPosition(i, point2D);
            }
        }
        this.g2d.drawGlyphVector(glyphVector, (float)d + f4, (float)d3);
        this.g2d.setFont(font2);
    }
}

