/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.bitmap;

import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import ai.org.krysalis.barcode4j.tools.DebugUtil;
import ai.org.krysalis.barcode4j.tools.UnitConv;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class ImageIOBitmapEncoder
implements BitmapEncoder {
    public ImageIOBitmapEncoder() throws ClassNotFoundException {
        Class.forName("javax.imageio.ImageIO");
    }

    public String[] getSupportedMIMETypes() {
        return ImageIO.getWriterMIMETypes();
    }

    public void encode(BufferedImage bufferedImage, OutputStream outputStream, String string, int n) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        ImageWriter imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        IIOMetadata iIOMetadata = this.setupMetadata(bufferedImage, imageWriter, string, n);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
        imageWriter.write(iIOImage);
        imageWriter.dispose();
        imageOutputStream.close();
    }

    private IIOMetadata setupMetadata(BufferedImage bufferedImage, ImageWriter imageWriter, String string, int n) throws IOException {
        IIOMetadata iIOMetadata;
        try {
            iIOMetadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), imageWriter.getDefaultWriteParam());
        }
        catch (Exception exception) {
            return null;
        }
        if (iIOMetadata == null) {
            return null;
        }
        if (!iIOMetadata.isReadOnly()) {
            if ("image/jpeg".equals(string) && "javax_imageio_jpeg_image_1.0".equals(iIOMetadata.getNativeMetadataFormatName())) {
                this.checkWritable(iIOMetadata);
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_jpeg_image_1.0");
                IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("JPEGvariety").item(0);
                IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode2.getElementsByTagName("app0JFIF").item(0);
                iIOMetadataNode3.setAttribute("resUnits", "1");
                iIOMetadataNode3.setAttribute("Xdensity", Integer.toString(n));
                iIOMetadataNode3.setAttribute("Ydensity", Integer.toString(n));
                iIOMetadata.setFromTree("javax_imageio_jpeg_image_1.0", iIOMetadataNode);
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                this.checkWritable(iIOMetadata);
                IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("Dimension");
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("HorizontalPixelSize");
                double d = 1.0 / (UnitConv.in2mm(1.0) / (double)n);
                iIOMetadataNode5.setAttribute("value", Double.toString(d));
                iIOMetadataNode4.appendChild(iIOMetadataNode5);
                iIOMetadataNode5 = new IIOMetadataNode("VerticalPixelSize");
                iIOMetadataNode5.setAttribute("value", Double.toString(d));
                iIOMetadataNode4.appendChild(iIOMetadataNode5);
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("Text");
                iIOMetadataNode5 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode5.setAttribute("keyword", "Software");
                iIOMetadataNode5.setAttribute("value", "Barcode4J");
                iIOMetadataNode5.setAttribute("encoding", "Unicode");
                iIOMetadataNode5.setAttribute("language", "en");
                iIOMetadataNode5.setAttribute("compression", "none");
                iIOMetadataNode6.appendChild(iIOMetadataNode5);
                iIOMetadataNode.appendChild(iIOMetadataNode4);
                iIOMetadataNode.appendChild(iIOMetadataNode6);
                try {
                    iIOMetadata.mergeTree("javax_imageio_1.0", iIOMetadataNode);
                }
                catch (Exception exception) {
                    try {
                        iIOMetadata.setFromTree("javax_imageio_1.0", iIOMetadataNode);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return iIOMetadata;
    }

    private void checkWritable(IIOMetadata iIOMetadata) throws IOException {
        if (iIOMetadata.isReadOnly()) {
            throw new IOException("Metadata is read-only. Cannot modify");
        }
    }

    private void dumpMetadata(IIOMetadata iIOMetadata) {
        String[] stringArray = iIOMetadata.getMetadataFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("--->" + stringArray[i]);
            DebugUtil.dumpNode(iIOMetadata.getAsTree(stringArray[i]));
        }
    }
}

