/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.bitmap;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import ai.org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import ai.org.krysalis.barcode4j.tools.UnitConv;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapBuilder {
    protected BitmapBuilder() {
        throw new UnsupportedOperationException();
    }

    public static BufferedImage prepareImage(BarcodeDimension barcodeDimension, int n, int n2) {
        return BitmapBuilder.prepareImage(barcodeDimension, 0, n, n2);
    }

    public static BufferedImage prepareImage(BarcodeDimension barcodeDimension, int n, int n2, int n3) {
        int n4 = UnitConv.mm2px(barcodeDimension.getWidthPlusQuiet(n), n2);
        int n5 = UnitConv.mm2px(barcodeDimension.getHeightPlusQuiet(n), n2);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, n3);
        return bufferedImage;
    }

    public static Graphics2D prepareGraphics2D(BufferedImage bufferedImage, BarcodeDimension barcodeDimension, int n, boolean bl) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setBackground(Color.white);
        graphics2D.setColor(Color.black);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.scale((double)bufferedImage.getWidth() / barcodeDimension.getWidthPlusQuiet(n), (double)bufferedImage.getHeight() / barcodeDimension.getHeightPlusQuiet(n));
        return graphics2D;
    }

    public static BufferedImage getImage(BarcodeGenerator barcodeGenerator, String string, int n) {
        BarcodeDimension barcodeDimension = barcodeGenerator.calcDimensions(string);
        BufferedImage bufferedImage = BitmapBuilder.prepareImage(barcodeDimension, n, 10);
        int n2 = 0;
        Graphics2D graphics2D = BitmapBuilder.prepareGraphics2D(bufferedImage, barcodeDimension, n2, true);
        Java2DCanvasProvider java2DCanvasProvider = new Java2DCanvasProvider(graphics2D, n2);
        barcodeGenerator.generateBarcode(java2DCanvasProvider, string);
        bufferedImage.flush();
        return bufferedImage;
    }

    public static void saveImage(BufferedImage bufferedImage, OutputStream outputStream, String string, int n) throws IOException {
        BitmapEncoder bitmapEncoder = BitmapEncoderRegistry.getInstance(string);
        bitmapEncoder.encode(bufferedImage, outputStream, string, n);
    }

    public static void outputBarcodeImage(BarcodeGenerator barcodeGenerator, String string, OutputStream outputStream, String string2, int n) throws IOException {
        BufferedImage bufferedImage = BitmapBuilder.getImage(barcodeGenerator, string, n);
        BitmapBuilder.saveImage(bufferedImage, outputStream, string2, n);
    }
}

