/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.upcean.UPCALogicImpl;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class UPCELogicImpl
extends UPCEANLogicImpl {
    private static final byte O = 0;
    private static final byte E = 1;
    private static final byte[][] NUMBER_SYSTEM_0 = new byte[][]{{1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1}};

    public UPCELogicImpl(ChecksumMode checksumMode) {
        super(checksumMode);
    }

    private static String substring(String string, int n, int n2) {
        return string.substring(n, n + n2);
    }

    public static String compactMessage(String string) {
        StringBuffer stringBuffer;
        byte by;
        block7: {
            UPCALogicImpl.validateMessage(string);
            String string2 = UPCALogicImpl.handleChecksum(string, ChecksumMode.CP_AUTO);
            byte by2 = UPCELogicImpl.extractNumberSystem(string2);
            if (by2 != 0 && by2 != 1) {
                return null;
            }
            by = Byte.parseByte(string2.substring(11, 12));
            stringBuffer = new StringBuffer();
            stringBuffer.append(Byte.toString(by2));
            try {
                String string3 = UPCELogicImpl.substring(string2, 1, 5);
                String string4 = UPCELogicImpl.substring(string2, 6, 5);
                String string5 = UPCELogicImpl.substring(string3, 2, 3);
                String string6 = UPCELogicImpl.substring(string4, 0, 2);
                if ("000|100|200".indexOf(string5) >= 0 && "00".equals(string6)) {
                    stringBuffer.append(UPCELogicImpl.substring(string3, 0, 2));
                    stringBuffer.append(UPCELogicImpl.substring(string4, 2, 3));
                    stringBuffer.append(string5.charAt(0));
                    break block7;
                }
                string6 = UPCELogicImpl.substring(string4, 0, 3);
                if ("300|400|500|600|700|800|900".indexOf(string5) >= 0 && "000".equals(string6)) {
                    stringBuffer.append(UPCELogicImpl.substring(string3, 0, 3));
                    stringBuffer.append(UPCELogicImpl.substring(string4, 3, 2));
                    stringBuffer.append("3");
                    break block7;
                }
                string5 = UPCELogicImpl.substring(string3, 3, 2);
                string6 = UPCELogicImpl.substring(string4, 0, 4);
                if ("10|20|30|40|50|60|70|80|90".indexOf(string5) >= 0 && "0000".equals(string6)) {
                    stringBuffer.append(UPCELogicImpl.substring(string3, 0, 4));
                    stringBuffer.append(UPCELogicImpl.substring(string4, 4, 1));
                    stringBuffer.append("4");
                    break block7;
                }
                string5 = UPCELogicImpl.substring(string3, 4, 1);
                string6 = UPCELogicImpl.substring(string4, 4, 1);
                if (!"0".equals(string5) && "5|6|7|8|9".indexOf(string6) >= 0) {
                    stringBuffer.append(string3);
                    stringBuffer.append(string6);
                    break block7;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        stringBuffer.append(Byte.toString(by));
        return stringBuffer.toString();
    }

    public static String expandMessage(String string) {
        String string2;
        byte by;
        char c = '\u0000';
        if (string.length() == 8) {
            c = string.charAt(7);
        }
        if ((by = UPCELogicImpl.extractNumberSystem(string2 = UPCELogicImpl.substring(string, 0, 7))) != 0 && by != 1) {
            throw new IllegalArgumentException("Invalid UPC-E message: " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Byte.toString(by));
        byte by2 = Byte.parseByte(UPCELogicImpl.substring(string2, 6, 1));
        if (by2 >= 0 && by2 <= 2) {
            stringBuffer.append(UPCELogicImpl.substring(string2, 1, 2));
            stringBuffer.append(Byte.toString(by2));
            stringBuffer.append("0000");
            stringBuffer.append(UPCELogicImpl.substring(string2, 3, 3));
        } else if (by2 == 3) {
            stringBuffer.append(UPCELogicImpl.substring(string2, 1, 3));
            stringBuffer.append("00000");
            stringBuffer.append(UPCELogicImpl.substring(string2, 4, 2));
        } else if (by2 == 4) {
            stringBuffer.append(UPCELogicImpl.substring(string2, 1, 4));
            stringBuffer.append("00000");
            stringBuffer.append(UPCELogicImpl.substring(string2, 5, 1));
        } else if (by2 >= 5 && by2 <= 9) {
            stringBuffer.append(UPCELogicImpl.substring(string2, 1, 5));
            stringBuffer.append("0000");
            stringBuffer.append(Byte.toString(by2));
        } else {
            throw new RuntimeException("Internal error");
        }
        String string3 = stringBuffer.toString();
        char c2 = UPCELogicImpl.calcChecksum(string3);
        if (c != '\u0000' && c != c2) {
            throw new IllegalArgumentException("Invalid checksum. Expected " + c2 + " but was " + c);
        }
        return string3 + c2;
    }

    private static byte extractNumberSystem(String string) {
        return Byte.parseByte(string.substring(0, 1));
    }

    private String convertUPCAtoUPCE(String string) {
        if (string.length() == 11 || string.length() == 12) {
            String string2 = UPCELogicImpl.compactMessage(string);
            if (string2 == null) {
                throw new IllegalArgumentException("UPC-A message cannot be compacted to UPC-E. Message: " + string);
            }
            return string2;
        }
        return string;
    }

    public static void validateMessage(String string) {
        UPCEANLogicImpl.validateMessage(string);
        if (string.length() < 7 || string.length() > 8) {
            throw new IllegalArgumentException("Message must be 7 or 8 characters long. Message: " + string);
        }
        byte by = UPCELogicImpl.extractNumberSystem(string);
        if (by < 0 || by > 1) {
            throw new IllegalArgumentException("Valid number systems for UPC-E are 0 or 1. Found: " + by);
        }
    }

    private String handleChecksum(String string) {
        ChecksumMode checksumMode = this.getChecksumMode();
        if (checksumMode == ChecksumMode.CP_AUTO) {
            if (string.length() == 7) {
                checksumMode = ChecksumMode.CP_ADD;
            } else if (string.length() == 8) {
                checksumMode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (checksumMode == ChecksumMode.CP_ADD) {
            if (string.length() != 7) {
                throw new IllegalArgumentException("Message must be 7 characters long");
            }
            return string + UPCELogicImpl.expandMessage(string).charAt(11);
        }
        if (checksumMode == ChecksumMode.CP_CHECK) {
            char c;
            if (string.length() != 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            char c2 = string.charAt(7);
            if (c2 != (c = UPCELogicImpl.expandMessage(string).charAt(11))) {
                throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
            }
            return string;
        }
        if (checksumMode == ChecksumMode.CP_IGNORE) {
            if (string.length() != 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            return string;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + checksumMode);
    }

    private byte selectCharset(byte by, byte by2, int n) {
        byte by3 = NUMBER_SYSTEM_0[by][n];
        if (by2 == 1) {
            by3 = by3 == 0 ? (byte)1 : 0;
        }
        return by3;
    }

    protected void drawUPCERightGuard(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.endBarGroup();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        String string2 = UPCELogicImpl.retrieveSupplemental(string);
        String string3 = UPCELogicImpl.removeSupplemental(string);
        string3 = this.convertUPCAtoUPCE(string3);
        UPCELogicImpl.validateMessage(string3);
        String string4 = string3 = this.handleChecksum(string3);
        if (string2 != null) {
            string4 = string4 + "+" + string2;
        }
        classicBarcodeLogicHandler.startBarcode(string4, string4);
        this.drawSideGuard(classicBarcodeLogicHandler);
        byte by = UPCELogicImpl.extractNumberSystem(string);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_LEAD, Byte.toString(by));
        classicBarcodeLogicHandler.endBarGroup();
        byte by2 = Byte.parseByte(string3.substring(7, 8));
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.substring(1, 7));
        for (int i = 1; i < 7; ++i) {
            byte by3 = this.selectCharset(by2, by, i - 1);
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(i), by3);
        }
        classicBarcodeLogicHandler.endBarGroup();
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_CHECK, Byte.toString(by2));
        classicBarcodeLogicHandler.endBarGroup();
        this.drawUPCERightGuard(classicBarcodeLogicHandler);
        if (string2 != null) {
            this.drawSupplemental(classicBarcodeLogicHandler, string2);
        }
        classicBarcodeLogicHandler.endBarcode();
    }
}

