/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DrawingUtil;
import ai.org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import ai.org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANBean;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import java.util.Stack;

public class UPCEANCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    private UPCEANBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private BarcodeDimension dim;
    private String msg;
    private String lastgroup;
    private double groupx;
    private boolean inMsgGroup;
    private boolean inSupplemental;
    private Stack groupStack = new Stack();

    public UPCEANCanvasLogicHandler(AbstractBarcodeBean abstractBarcodeBean, Canvas canvas) {
        if (!(abstractBarcodeBean instanceof UPCEANBean)) {
            throw new IllegalArgumentException("This LogicHandler can only be used with UPC and EAN barcode implementations");
        }
        this.bcBean = (UPCEANBean)abstractBarcodeBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String string, String string2) {
        this.msg = string;
        this.dim = this.bcBean.calcDimensions(string);
        this.canvas.establishDimensions(this.dim);
        this.x = this.getStartX();
        this.inMsgGroup = false;
        this.inSupplemental = false;
    }

    public void startBarGroup(BarGroup barGroup, String string) {
        if (barGroup != BarGroup.UPC_EAN_GUARD) {
            if (barGroup == BarGroup.UPC_EAN_GROUP) {
                this.inMsgGroup = true;
                this.groupx = this.x;
                this.lastgroup = string;
            } else if (barGroup == BarGroup.UPC_EAN_LEAD) {
                this.lastgroup = string;
            } else if (barGroup == BarGroup.UPC_EAN_CHECK) {
                if (!this.inMsgGroup) {
                    this.lastgroup = string;
                }
            } else if (barGroup == BarGroup.UPC_EAN_SUPP) {
                this.inSupplemental = true;
                this.x += this.bcBean.getQuietZone();
                this.groupx = this.x;
            }
        }
        this.groupStack.push(barGroup);
    }

    public void addBar(boolean bl, int n) {
        double d = this.bcBean.getBarWidth(n);
        if (bl) {
            if (!this.inSupplemental) {
                if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                    this.canvas.drawRectWH(this.x, 0.0, d, this.bcBean.getHeight());
                } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                    double d2;
                    double d3;
                    if (this.inMsgGroup) {
                        d3 = this.bcBean.getBarHeight();
                        d2 = this.bcBean.getHumanReadableHeight();
                    } else {
                        d3 = this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0;
                        d2 = this.bcBean.getHumanReadableHeight() / 2.0;
                    }
                    this.canvas.drawRectWH(this.x, d2, d, d3);
                } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                    double d4 = this.inMsgGroup ? this.bcBean.getBarHeight() : this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0;
                    this.canvas.drawRectWH(this.x, 0.0, d, d4);
                }
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                double d5 = this.bcBean.getBarHeight();
                double d6 = this.bcBean.getHumanReadableHeight();
                this.canvas.drawRectWH(this.x, d6, d, d5);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                double d7 = this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0 - this.bcBean.getHumanReadableHeight();
                double d8 = this.bcBean.getHumanReadableHeight() / 2.0;
                this.canvas.drawRectWH(this.x, d8, d, d7);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                double d9 = this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0 - this.bcBean.getHumanReadableHeight();
                double d10 = this.bcBean.getHumanReadableHeight();
                this.canvas.drawRectWH(this.x, d10, d, d9);
            }
        }
        this.x += d;
    }

    private boolean isEAN() {
        return this.bcBean instanceof EAN13Bean || this.bcBean instanceof EAN8Bean;
    }

    public void endBarGroup() {
        BarGroup barGroup = (BarGroup)this.groupStack.pop();
        if (barGroup == BarGroup.UPC_EAN_GROUP) {
            this.inMsgGroup = false;
            if (this.lastgroup == null) {
                return;
            }
            int n = this.lastgroup.indexOf(":");
            String string = this.lastgroup;
            if (n >= 0) {
                String string2 = new Character(string.charAt(0)).toString();
                this.drawLeadChar(string2);
                string = string.substring(n + 1);
            }
            this.drawGroupText(string);
        } else if (barGroup == BarGroup.UPC_EAN_LEAD) {
            if (!this.isEAN()) {
                this.drawLeadChar(this.lastgroup);
            }
        } else if (barGroup == BarGroup.UPC_EAN_CHECK) {
            if (!this.isEAN()) {
                this.drawTrailingChar(this.lastgroup);
            }
        } else if (barGroup == BarGroup.UPC_EAN_SUPP) {
            this.drawSupplementalText(UPCEANLogicImpl.retrieveSupplemental(this.msg));
            this.inSupplemental = false;
        }
    }

    private void drawLeadChar(String string) {
        double d = 7.0 * this.bcBean.getBarWidth(1);
        double d2 = this.getStartX() - 3.0 * this.bcBean.getBarWidth(1) - d;
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawText(this.canvas, this.bcBean, string, d2, d2 + d, this.bcBean.getHumanReadableHeight(), TextAlignment.TA_CENTER);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawText(this.canvas, this.bcBean, string, d2, d2 + d, this.bcBean.getHeight(), TextAlignment.TA_CENTER);
            }
        }
    }

    private void drawTrailingChar(String string) {
        double d = 7.0 * this.bcBean.getBarWidth(1);
        double d2 = this.getStartX() + this.dim.getWidth() - this.bcBean.supplementalWidth(this.msg) + 3.0 * this.bcBean.getBarWidth(1);
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawText(this.canvas, this.bcBean, string, d2, d2 + d, this.bcBean.getHumanReadableHeight(), TextAlignment.TA_CENTER);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawText(this.canvas, this.bcBean, string, d2, d2 + d, this.bcBean.getHeight(), TextAlignment.TA_CENTER);
            }
        }
    }

    private void drawGroupText(String string) {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawText(this.canvas, this.bcBean, string, this.groupx + this.bcBean.getBarWidth(1), this.x - this.bcBean.getBarWidth(1), this.bcBean.getHumanReadableHeight(), TextAlignment.TA_JUSTIFY);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawText(this.canvas, this.bcBean, string, this.groupx + this.bcBean.getBarWidth(1), this.x - this.bcBean.getBarWidth(1), this.bcBean.getHeight(), TextAlignment.TA_JUSTIFY);
            }
        }
    }

    private void drawSupplementalText(String string) {
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            DrawingUtil.drawText(this.canvas, this.bcBean, string, this.groupx, this.x, this.bcBean.getHeight(), TextAlignment.TA_CENTER);
        } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            DrawingUtil.drawText(this.canvas, this.bcBean, string, this.groupx, this.x, this.bcBean.getHumanReadableHeight(), TextAlignment.TA_CENTER);
        }
    }

    public void endBarcode() {
    }
}

