/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class EAN8LogicImpl
extends UPCEANLogicImpl {
    public EAN8LogicImpl(ChecksumMode checksumMode) {
        super(checksumMode);
    }

    public static void validateMessage(String string) {
        UPCEANLogicImpl.validateMessage(string);
        if (string.length() < 7 || string.length() > 8) {
            throw new IllegalArgumentException("Message must be 7 or 8 characters long. Message: " + string);
        }
    }

    private String handleChecksum(String string) {
        ChecksumMode checksumMode = this.getChecksumMode();
        if (checksumMode == ChecksumMode.CP_AUTO) {
            if (string.length() == 7) {
                checksumMode = ChecksumMode.CP_ADD;
            } else if (string.length() == 8) {
                checksumMode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (checksumMode == ChecksumMode.CP_ADD) {
            if (string.length() > 7) {
                throw new IllegalArgumentException("Message is too long (max. 7 characters)");
            }
            if (string.length() < 7) {
                throw new IllegalArgumentException("Message must be 7 characters long");
            }
            return string + EAN8LogicImpl.calcChecksum(string);
        }
        if (checksumMode == ChecksumMode.CP_CHECK) {
            char c;
            if (string.length() > 8) {
                throw new IllegalArgumentException("Message is too long (max. 8 characters)");
            }
            if (string.length() < 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            char c2 = string.charAt(7);
            if (c2 != (c = EAN8LogicImpl.calcChecksum(string.substring(0, 7)))) {
                throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
            }
            return string;
        }
        if (checksumMode == ChecksumMode.CP_IGNORE) {
            return string;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + checksumMode);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        char c;
        String string2 = EAN8LogicImpl.retrieveSupplemental(string);
        String string3 = EAN8LogicImpl.removeSupplemental(string);
        EAN8LogicImpl.validateMessage(string3);
        String string4 = string3 = this.handleChecksum(string3);
        if (string2 != null) {
            string4 = string4 + "+" + string2;
        }
        classicBarcodeLogicHandler.startBarcode(string4, string4);
        this.drawSideGuard(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.substring(0, 4));
        for (c = '\u0000'; c < '\u0004'; ++c) {
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(c), 0);
        }
        classicBarcodeLogicHandler.endBarGroup();
        this.drawCenterGuard(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.substring(4, 8));
        for (c = '\u0004'; c < '\u0007'; ++c) {
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(c), 2);
        }
        c = string3.charAt(7);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(c).toString());
        this.encodeChar(classicBarcodeLogicHandler, c, 2);
        classicBarcodeLogicHandler.endBarGroup();
        classicBarcodeLogicHandler.endBarGroup();
        this.drawSideGuard(classicBarcodeLogicHandler);
        if (string2 != null) {
            this.drawSupplemental(classicBarcodeLogicHandler, string2);
        }
        classicBarcodeLogicHandler.endBarcode();
    }
}

