/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class EAN13LogicImpl
extends UPCEANLogicImpl {
    private static final byte A = 0;
    private static final byte B = 1;
    private static final byte[][] FIRSTFLAG = new byte[][]{{0, 0, 0, 0, 0}, {0, 1, 0, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 1, 0}, {1, 0, 0, 1, 1}, {1, 1, 0, 0, 1}, {1, 1, 1, 0, 0}, {1, 0, 1, 0, 1}, {1, 0, 1, 1, 0}, {1, 1, 0, 1, 0}};

    public EAN13LogicImpl(ChecksumMode checksumMode) {
        super(checksumMode);
    }

    public static void validateMessage(String string) {
        UPCEANLogicImpl.validateMessage(string);
        if (string.length() < 12 || string.length() > 13) {
            throw new IllegalArgumentException("Message must be 12 or 13 characters long. Message: " + string);
        }
    }

    private String handleChecksum(String string) {
        ChecksumMode checksumMode = this.getChecksumMode();
        if (checksumMode == ChecksumMode.CP_AUTO) {
            if (string.length() == 12) {
                checksumMode = ChecksumMode.CP_ADD;
            } else if (string.length() == 13) {
                checksumMode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (checksumMode == ChecksumMode.CP_ADD) {
            if (string.length() > 12) {
                throw new IllegalArgumentException("Message is too long (max. 12 characters)");
            }
            if (string.length() < 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            return string + EAN13LogicImpl.calcChecksum(string);
        }
        if (checksumMode == ChecksumMode.CP_CHECK) {
            char c;
            if (string.length() > 13) {
                throw new IllegalArgumentException("Message is too long (max. 13 characters)");
            }
            if (string.length() < 13) {
                throw new IllegalArgumentException("Message must be 13 characters long");
            }
            char c2 = string.charAt(12);
            if (c2 != (c = EAN13LogicImpl.calcChecksum(string.substring(0, 12)))) {
                throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
            }
            return string;
        }
        if (checksumMode == ChecksumMode.CP_IGNORE) {
            return string;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + checksumMode);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        char c;
        String string2 = EAN13LogicImpl.retrieveSupplemental(string);
        String string3 = EAN13LogicImpl.removeSupplemental(string);
        EAN13LogicImpl.validateMessage(string3);
        String string4 = string3 = this.handleChecksum(string3);
        if (string2 != null) {
            string4 = string4 + "+" + string2;
        }
        classicBarcodeLogicHandler.startBarcode(string4, string4);
        this.drawSideGuard(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.charAt(0) + ":" + string3.substring(1, 7));
        this.encodeChar(classicBarcodeLogicHandler, string3.charAt(1), 0);
        byte by = (byte)Character.digit(string3.charAt(0), 10);
        for (c = '\u0002'; c < '\u0007'; ++c) {
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(c), FIRSTFLAG[by][c - 2]);
        }
        classicBarcodeLogicHandler.endBarGroup();
        this.drawCenterGuard(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.substring(7, 13));
        for (c = '\u0007'; c < '\f'; ++c) {
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(c), 2);
        }
        c = string3.charAt(12);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(c).toString());
        this.encodeChar(classicBarcodeLogicHandler, c, 2);
        classicBarcodeLogicHandler.endBarGroup();
        classicBarcodeLogicHandler.endBarGroup();
        this.drawSideGuard(classicBarcodeLogicHandler);
        if (string2 != null) {
            this.drawSupplemental(classicBarcodeLogicHandler, string2);
        }
        classicBarcodeLogicHandler.endBarcode();
    }
}

